import { getAuthToken } from "./auth";

export const fetchLatestInspiration=(eventId)=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/inspirations-latest` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchUserDetail=()=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/user-details` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchEventCategories=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/categories` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchCountries=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/countries` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchEventAll=(category='all', pageOffset=null, perPage=null, filter_type=null)=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        let qparams='';
        if(category!=='all'){
            qparams += `category=${category}`;
        }
        if(pageOffset!==null){
            qparams += `&page=${pageOffset}`;
        }
        if(perPage!==null){
            qparams += `&per_page=${perPage}`;
        }
        if(filter_type!==null){
            qparams += `&filter_type=${filter_type}`;
        }
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/userevents?${qparams}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchEventSharedAll=(category='all', pageOffset=null, perPage=null)=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        let qparams='';
        if(category!=='all'){
            qparams += `category=${category}`;
        }
        if(pageOffset!==null){
            qparams += `&page=${pageOffset}`;
        }
        if(perPage!==null){
            qparams += `&per_page=${perPage}`;
        }
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/share-events?${qparams}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchEventSingle=(eventId)=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/events/single/${eventId}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchConnections=(pageOffset=null, perPage=null)=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        let qparams='';
        if(pageOffset!==null){
            qparams += `&page=${pageOffset}`;
        }
        if(perPage!==null){
            qparams += `&per_page=${perPage}`;
        }
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connections?${qparams}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchSharedEventConnections=(eventId)=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/eventshared?event_id=${eventId}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchByEmail = (search) => {
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var formdata = new FormData();
        if (search) {
            formdata.append('search', search);
        }

        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);

        const requestOptions = {
            method: 'POST',
            redirect: 'follow',
            headers: secureHeader,
            body: formdata,
        };

        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/user-by-email`, requestOptions)
            .then(response => response.text())
            .then(result => {
                resolve(JSON.parse(result));
            })
            .catch(error => {
                console.log('error', error);
                reject(error);
            });
    });
};


export const fetchAllRelations=()=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/relations` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}


export const fetchChallangesAll=(category='all', pageOffset=null, perPage=null)=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        let qparams='';
        if(category!=='all'){
            qparams += `category=${category}`;
        }
        if(pageOffset!==null){
            qparams += `&page=${pageOffset}`;
        }
        if(perPage!==null){
            qparams += `&per_page=${perPage}`;
        }
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/userchallange?${qparams}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchChallangeSingle=(challangeId)=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/challenges/single/${challangeId}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchChallangeCategories=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/challange-categories` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchChallangeType=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/challangetypes` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchPendingSentRequest=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connections/sentpending` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchPendingRequest=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connections/pending` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchAllBadges=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/badge-masters` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchSelectedBadges=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/user-badges` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}


export const fetchResources=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/resource-centers` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchAdminChallange=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/challanges/admin` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchKeepSakes=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/userkeeps-sakes` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}
export const fetchKeepSakesSingle=(keepsakesId)=>{
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/keeps-sakes/${keepsakesId}` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

// Announcement
export const fetchListAllPost=()=>{    
    const token=getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization','Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/announcments` , requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchGetAllComments = (postId) => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/comments`);
        url.searchParams.append('post_id', postId);
        
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchDeletePost = (postId) => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        
        const requestOptions = {
            method: 'DELETE',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/announcments/${postId}`);        
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}


export const fetchPlans=()=>{  
    return new Promise((resolve, reject) => {
        const requestOptions = {
            method: 'GET',
            redirect: 'follow'
        };
        fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/plans`, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchInvoice = () => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/invoices`);      
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}


export const fetchTestimonials = () => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        const requestOptions = {
            method: 'GET',
            redirect: 'follow'
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/testimonials`);      
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchStatistics = () => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/user/statistics`);      
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}


export const fetchNewsletters = (email) => {
    return new Promise((resolve) => {
        var formdata = new FormData();
        formdata.append('email', email);
        const requestOptions = {
            method: 'POST',
            redirect: 'follow',
            body: formdata,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/newsletters`);      
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}

export const fetchSendMessage = async (receiverId, message, image) => {
    try {
        const token = getAuthToken();
        const apiUrl = `${process.env.NEXT_PUBLIC_API_URL}api/v1/messages`;
        
        var formdata = new FormData();
        formdata.append("receiver_id", receiverId);
        formdata.append("message", message);
        if (image) formdata.append("image", image);
        
        const requestOptions = {
            method: "POST",
            headers: { Authorization: `Bearer ${token}` },
            body: formdata,
        };
        
        const response = await fetch(apiUrl, requestOptions);
        if (!response.ok) {
            const errorText = await response.text();
            throw new Error(`API Error: ${errorText}`);
        }
        
        const text = await response.text();
        try {
            return JSON.parse(text);
        } catch (err) {
            console.error("JSON Parse Error:", text);
            throw new Error("Invalid JSON response from server");
        }
    } catch (error) {
        console.error("Fetch Error:", error);
        return { success: false, error: error.message };
    }
};

export const fetchReceiveMessage = () => {    
    const token = getAuthToken();
    return new Promise((resolve, reject) => {
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        const requestOptions = {
            method: 'GET',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}api/v1/messages`);      
        fetch(url, requestOptions)
        .then(response => response.text())
        .then(result => {    
            resolve(JSON.parse(result));
        })
        .catch(error => console.log('error', error));
    });
}
