import { createSlice } from "@reduxjs/toolkit";
import Cookies from "js-cookie";
import { logoutUser } from "@/utils/auth";

export const userSlice = createSlice({
  name: 'userObj',
  initialState: {
    user: {}
  },
  reducers: {
    loginAction: (state, action) => {
      const { token, userId } = action.payload;

      Cookies.set('auth_token', token, {
        secure: true,
        sameSite: 'Strict',
        expires: 1
      });
      Cookies.set('isUserAuthenticated', 'true', {
        secure: true,
        sameSite: 'Strict',
        expires: 1
      });
    //   Cookies.set('user_id', userId, {
    //     secure: true,
    //     sameSite: 'Strict',
    //     expires: 1
    //   });
    },
    logoutAction: (state) => {
      logoutUser();
      Cookies.remove('auth_token');
      Cookies.remove('isUserAuthenticated');
      Cookies.remove('user_id');
      state.user = null;
    },
    getUserDetailAction: (state, action) => {
      state.user = action.payload;
    }
  }
});

export const { loginAction, logoutAction, getUserDetailAction } = userSlice.actions;
export default userSlice.reducer;
