import { createSlice } from "@reduxjs/toolkit";
export const EventsSlice = createSlice({
    name:'eventsObj',
    initialState:{
        eventsData:{},
    },
    reducers:{
        fetchEventsAction:(state, action)=>{            
            state.eventsData = action.payload;
        },
        addEventsAction:(state, action)=>{
            state.eventsData = [ 
                action.payload,
                ...state.eventsData
            ];
        },
        /*updateEventAction:(state, action)=>{
            var index = state.eventsData.findIndex(x=> x.id === action.payload.id);
            const oldState=state.eventsData;
            const newState= [
                ...oldState.slice(0, index), // everything before current post
                {
                   ...oldState[index],
                   updated_at: action.payload.updated_at,
                   title: action.payload.title,
                   file_url: action.payload.file_url,
                   public_visibility: action.payload.public_visibility
                },
                ...oldState.slice(index + 1), // everything after current post
            ]
            state.folderData=newState;
        },*/
        
        deleteEventAction:(state, action)=>{            
            const newState = state.eventsData.filter(obj => {
                return obj.id !== action.payload.id;
            });
            state.eventsData = newState;
        },
    },
});

export const { fetchEventsAction, addEventsAction, deleteEventAction } = EventsSlice.actions;
export default EventsSlice.reducer;