import { createSlice } from "@reduxjs/toolkit";
export const ChallangesSlice = createSlice({
    name:'challangesListObj',
    initialState:{
        challangesData:{},
    },
    reducers:{
        fetchChallangesAction:(state, action)=>{            
            state.challangesData = action.payload;
        },
        addChallangesAction:(state, action)=>{
            state.challangesData = [ 
                action.payload,
                ...state.challangesData
            ];
        },
        /*updateChallangesAction:(state, action)=>{
            var index = state.challangesData.findIndex(x=> x.id === action.payload.id);
            const oldState=state.challangesData;
            const newState= [
                ...oldState.slice(0, index), // everything before current post
                {
                   ...oldState[index],
                   updated_at: action.payload.updated_at,
                   title: action.payload.title,
                   file_url: action.payload.file_url,
                   public_visibility: action.payload.public_visibility
                },
                ...oldState.slice(index + 1), // everything after current post
            ]
            state.folderData=newState;
        },*/
        
        deleteChallangeAction:(state, action)=>{            
            const newState = state.challangesData.filter(obj => {
                return obj.id !== action.payload.id;
            });
            state.challangesData = newState;
        },
    },
});

export const { fetchChallangesAction, addChallangesAction, deleteChallangeAction } = ChallangesSlice.actions;
export default ChallangesSlice.reducer;