import { createSlice } from "@reduxjs/toolkit";
export const AnnouncementsSlice = createSlice({
    name:'announcementListObj',
    initialState:{
        announcementsData:{},
    },
    reducers:{
        fetchAnnouncementsAction:(state, action)=>{            
            state.announcementsData = action.payload;
        },
        deleteAnnouncementAction:(state, action)=>{            
            const newState = state.announcementsData.filter(obj => {
                return obj.id !== action.payload.id;
            });
            state.announcementsData = newState;            
        },
        likeAnnouncementAction:(state,action)=>{
            var index = state.announcementsData.findIndex(x=> x.id === action.payload.id);
            if (index !== -1) {
                // Directly update the specific object
                state.announcementsData[index].likes = action.payload.likes;
                state.announcementsData[index].likes_count = action.payload.likes_count;
            }
        },
        updateCommentCountAction:(state,action)=>{
            var index = state.announcementsData.findIndex(x=> x.id === action.payload.id);
            if (index !== -1) {
                // Directly update the specific object
                state.announcementsData[index].comments_count = action.payload.comments_count;
            }
        }
    },
});

export const { fetchAnnouncementsAction, deleteAnnouncementAction, likeAnnouncementAction, updateCommentCountAction } = AnnouncementsSlice.actions;
export default AnnouncementsSlice.reducer;