"use client";
import { configureStore, combineReducers } from "@reduxjs/toolkit";
import userReducer from './slices/userSlice';
import eventsReducer from './slices/eventsSlice';
import sharedEventReducer from './slices/sharedEventsSlice';
import announcementsReducer from './slices/announcementsSlice';

import {
    persistReducer,
    FLUSH,
    REHYDRATE,
    PAUSE,
    PERSIST,
    PURGE,
    REGISTER, 
} from 'redux-persist';

import storage from 'redux-persist/lib/storage';
import autoMergeLevel2 from 'redux-persist/lib/stateReconciler/autoMergeLevel2';

const rootReducer = combineReducers({ 
    user: userReducer,
    events: eventsReducer,
    sharedevents: sharedEventReducer,
    announcements: announcementsReducer
});

const rootPersistConfig = {
    key: 'root',
    storage,
    stateReconciler:autoMergeLevel2,
    whitelist: []
}

const persistedReducer = persistReducer(rootPersistConfig, rootReducer);

export const store = configureStore({
    reducer: persistedReducer,
    middleware: (getDefaultMiddleware) => [
        ...getDefaultMiddleware({
          serializableCheck: {
            ignoredActions: [FLUSH, REHYDRATE, PAUSE, PERSIST, PURGE, REGISTER],
          },
        }),
    ],
})
export default store;