import { NextResponse } from 'next/server';

export function middleware(req) {
    const isAuthenticated = Boolean(req.cookies.get('auth_token'));
    const url = req.nextUrl;

    if (url.pathname === '/auth') {
        return NextResponse.redirect(new URL('/', req.url));
    }
    // Redirect unauthenticated users trying to access protected routes
    if (url.pathname.startsWith('/dashboard') && !isAuthenticated) {
        return NextResponse.redirect(new URL('/auth/login', req.url));
    }

    // Redirect authenticated users away from the login and signup pages
    if (isAuthenticated && (url.pathname.startsWith('/auth/login') || url.pathname.startsWith('/auth/signup'))) {
        return NextResponse.redirect(new URL('/dashboard', req.url));
    }

    return NextResponse.next();
}

export const config = {
    matcher: ['/dashboard/:path*', '/auth', '/auth/login', '/auth/signup'],
};