'use client';
import React, { useState, useEffect } from 'react';
import { fetchPlans } from '@/utils/apiActions';

const PricingSection = () => {
    const [plansData, setPlansData] = useState([]);
    const getPlans = async () => {
        try {
            const plansdata = await fetchPlans();
            setPlansData(plansdata.data);            
        } catch (error) {
            console.error("Error fetching resources:", error);
        }
    };
    useEffect(() => {
        getPlans();
    }, []);
    return (
        <section
            id="pricing"
            className="section-padding pb-80 image-info-section has-shapes bg-light-gray has-bg-brash bg-brash-y"
            style={{
                backgroundImage:
                    "url('images/brushes/section-top.svg'), url('images/brushes/section-bottom.svg')",
                backgroundPosition: 'top, bottom',
                backgroundRepeat: 'no-repeat, no-repeat',
                backgroundSize: 'contain, contain',
            }}
        >
            <div className="main-container">
                <div className="row justify-content-center">
                    <div className="col-lg-6 col-md-9 text-center mb-40">
                        <h2 className="section-title">
                            Choose <strong>Pricing</strong>
                        </h2>
                        <p>
                        We offer a subscription-based payment with extra benefits for members signing up. The base prices and features are below.
                        </p>
                    </div>
                </div>
                {plansData.length > 0 && (
                    <div>
                        <div className="row justify-content-center">
                            <div className="col-xl-6 col-md-6">
                                <div className="card rounded shadow border-0 mb-30">
                                    <div className="card-body p-30">
                                        <span className="h2 font-weight-bold d-inline-flex">
                                            $<span className="data-count">{plansData[0].price}</span>
                                        </span>
                                        <span
                                            className="text-monthly"
                                        >
                                            \{plansData[0].payment_frequency}
                                        </span>
                                        <h3 className="font-weight-600 mt-15 mb-0">{plansData[0].name}</h3>
                                        <p className="border-bottom pb-15">
                                            {/* {plansData[0].subtitle} */}
                                        </p>
                                        <ul className="list-unstyled check-list-2 mt-30 mb-40">
                                            {plansData.map((item, index)=>(
                                                <li className="mb-25" key={index}>
                                                    <div dangerouslySetInnerHTML={{ __html: item.description }}></div>
                                                </li>
                                            ))}
                                        </ul>
                                        <div className="d-flex justify-content-center">
                                            <a href="/dashboard/subscriptionplan" className="btn btn-outline-primary d-block">
                                                subscribe now
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                )}

            </div>
        </section>
    );
};

export default PricingSection;
