'use client';
import { useState } from "react";
import ImageNotFound from '../../../public/images/logo.png';
import moment from 'moment';
import Image from 'next/image';
import { getAuthToken } from "@/utils/auth";

const StartChallangesPopup = (props) => {
    const { setShowPopup, adminData } = props;
    const [loading, setLoading] = useState(false);
    const [messages, setMessages] = useState({});
    const [loadingStates, setLoadingStates] = useState({});
    const token = getAuthToken();

    const participateChallange = async (challangeItem) => {
        
        setLoadingStates((prev) => ({
            ...prev,
            [challangeItem.id]: true,
        }));

        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);
        const formdata = new FormData();
        formdata.append("challange_id", challangeItem.id);
        formdata.append("status", 'start');

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/userchallanges/handle`, requestOptions)
            .then((response) => response.text())
            .then((result) => {
                setLoadingStates((prev) => ({
                    ...prev,
                    [challangeItem.id]: false, 
                }));
                setMessages((prevMessages) => ({
                    ...prevMessages,
                    [challangeItem.id]: 'Thank You', 
                }));
                setTimeout(() => {
                    window.location.href = '/dashboard/wellness-center/challanges';
                }, 3000);
            })
            .catch((error) => {
                console.error(error);
                setLoadingStates((prev) => ({
                    ...prev,
                    [challangeItem.id]: false,
                }));
                setMessages((prevMessages) => ({
                    ...prevMessages,
                    [challangeItem.id]: error.toString(), 
                }));
            });
    };
    

    const closePopup = () => {
        setShowPopup(false);
    };

    return (
        <>
            <div className="popup-screen">
                <div className="popup-screen-inner p-0">
                    {!loading ?
                        <>
                            <div className="view-challanges-ui p-2 p-md-4">
                                <div className="custom-scroll popup-screen-wrap overflow-y-auto h-96">
                                    {adminData?.length > 0 ? (
                                        (() => {
                                            let hasChallenges = false;
                                            return adminData
                                                .filter(item => item.status === 'not-participated')
                                                .map((item, index) => {
                                                    hasChallenges = true;
                                                    return (
                                                        <div key={index} className="border p-2 p-md-3 mb-2">
                                                            <div className="d-flex gap-1 gap-md-3">
                                                                <div className="position-relative">
                                                                    {item?.photo?.preview_url ? (
                                                                        <Image
                                                                            src={item?.photo?.preview_url}
                                                                            alt={item.name}
                                                                            width={100}
                                                                            height={100}
                                                                            className="rounded-2"
                                                                            style={{ objectFit: 'cover' }}
                                                                        />
                                                                    ) : (
                                                                        <div className="d-flex flex-column align-items-center w-100 h-100 justify-content-center bg-light">
                                                                            <Image
                                                                                src={ImageNotFound}
                                                                                width={120}
                                                                                height={120}
                                                                                alt="Image not found"
                                                                                style={{ objectFit: 'cover' }}
                                                                            />
                                                                        </div>
                                                                    )}
                                                                </div>
                                                                <div className="w-100">
                                                                    <div className="d-flex flex-wrap align-items-start justify-content-between">
                                                                        <div>
                                                                            <h5 className="fw-bold border-grey mb-2">{item.name}</h5>
                                                                            <div>
                                                                                <i className="ti-calendar me-2"></i>
                                                                                {moment(item.start_date).format('DD-MM-YYYY') !== moment(item.end_date).format('DD-MM-YYYY') ? (
                                                                                    <>
                                                                                        {moment(item.start_date).format('DD MMM, YYYY')} TO {moment(item.end_date).format('DD MMM, YYYY')}
                                                                                    </>
                                                                                ) : (
                                                                                    moment(item.start_date).format('DD MMM, YYYY')
                                                                                )}
                                                                            </div>
                                                                            <div>
                                                                                <i className="ti-timer me-2"></i>
                                                                                {moment(item.start_date).format('HH:mm A')} TO {moment(item.end_date).format('HH:mm A')}
                                                                            </div>
                                                                            <div className="mb-0">
                                                                                <p><b>Category</b>: {item.challangecategory_name}</p>
                                                                                <p><b>Type</b>: {item.challange_type}</p>
                                                                            </div>
                                                                        </div>
                                                                        {loadingStates[item.id] ?
                                                                            <button type="button" className="btn btn-primary btn-tiny align-self-start ">
                                                                                <svg version="1.1" id="loader-1" x="0px" y="0px" width="16px" height="16px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40">
                                                                                    <path opacity="0.5" fill="#fff" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#fff" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                                                                            </button>
                                                                            :
                                                                            <>
                                                                                {messages[item.id] === undefined ?
                                                                                    <button
                                                                                        type="button"
                                                                                        className="btn btn-primary btn-tiny align-self-start mt-2"
                                                                                        onClick={() => participateChallange(item)}
                                                                                    >
                                                                                        Participate
                                                                                    </button>
                                                                                    :
                                                                                    <p className="alert alert-success py-1 px-1 fs-12 align-self-start fw-bold px-2">{messages[item.id]}</p>
                                                                                }
                                                                            </>
                                                                        }
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div className="border-top mt-2 pt-2">
                                                                <h5 className="fw-bold border-grey">Overview</h5>
                                                                <p>{item.description}</p>
                                                            </div>
                                                        </div>
                                                    );
                                                }).concat(
                                                    !hasChallenges && (
                                                        <h2 key="no-challenges" className="text-center section-title mb-0 text-md">
                                                            No challenges Found.
                                                        </h2>
                                                    )
                                                );
                                        })()
                                    ) : (
                                        <h4 className="text-center section-title mb-0 text-md">No challenges Found.</h4>
                                    )}
                                </div>
                                <div className="position-absolute right-0 view-challanges-inner">
                                    <i className="ti-close" onClick={closePopup}></i>
                                </div>
                            </div>
                        </>
                        :
                        <>
                            <div className="css-loader w-100">
                                <div className="lds-ripple"><div></div><div></div></div>
                            </div>
                        </>
                    }
                </div>
            </div>
        </>
    );
}

export default StartChallangesPopup;
