'use client';
import { useState, useEffect } from "react";
import Image from "next/image";
import { fetchSharedEventConnections } from "@/utils/apiActions";


const ShareConnectonRow=(props)=>{
    const {connectionItem, id, isSelected, onCheckboxChange} = props;
    const handleChange = (event) => {
        onCheckboxChange(id, event.target.checked);
    };

    return(
        <div className={`share-connection-card d-flex gap-3 p-3 mb-4 align-items-center border border-primary rounded`}>
            {connectionItem.event_shared_flag!=='already_shared' &&
                <div className="form-check">
                    <input className="form-check-input" type="checkbox" checked={isSelected} onChange={handleChange} />
                </div>
            }
            <div className="image-wrapper position-relative rounded-circle user-pic-40 rounded-circle border border-primary overflow-hidden">
            {connectionItem?.photo?.thumbnail && connectionItem.photo.thumbnail.trim() !== "" ?
                <Image
                    src={connectionItem.photo.thumbnail}
                    alt={connectionItem.name || "User Image"}
                    fill
                    style={{ objectFit: "cover" }}
                />
                :
                <i className="ti-user"></i>
            }

            </div>
            <div className="flex-grow-1">
                <div className="connection-name">{connectionItem.name}</div>
            </div>
            {connectionItem.event_shared_flag==='already_shared' &&
                <p className="text-success fw-bold">Event Shared</p>
            }   
        </div>
    )
}

const ShareEventToConnectionPopup=(props)=>{
    const {setShowPopup, eventItem, token} = props;
    const [isMounted, setIsMounted] = useState(false);
    const [loading, setLoading] = useState(false);
    const [message, setMessage] = useState(null);
    const [connections, setConnections] = useState([]);
    const [selectedConnections, setSelectedConnections] = useState([]);
    const [shareLoading, setShareLoding] = useState(false);

    const closePopup=()=>{
        setShowPopup(false);
    }

    const getConnections=async()=>{
        setLoading(true);
        const [connectionData] = await Promise.all([
            fetchSharedEventConnections(eventItem.id),
        ]);

        if(connectionData.status===1){
            setConnections(connectionData.data);
        }
        setLoading(false);
    }

    const handleCheckboxChange=(id, isSelected)=>{
        setMessage(null);
        setSelectedConnections((prevSelectedConnections) => {
            if (isSelected) {
              return [...prevSelectedConnections, id]; // Add the row ID if selected
            } else {
              return prevSelectedConnections.filter((cid) => cid !== id); // Remove if unchecked
            }
        });
    }

    const handleSubmit = async() => {
        setMessage(null);
        const formdata = new FormData();
        formdata.append("event_id", eventItem.id);
        formdata.append("action", 'add');

        selectedConnections.forEach((sc)=>{
            formdata.append("connection_ids[]", sc);
        });        
        
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setShareLoding(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/handle-sharedevents`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setShareLoding(false);
            setMessage('Events Shared Successfully');
            setSelectedConnections([]);
        })
        .catch((error) => {
            console.error(error);
            setMessage(error);
            setShareLoding(false);
        });
    };

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getConnections();
    },[isMounted]);

    return(
        <>
        <div className="popup-screen">
            <div className="popup-screen-inner position-relative share-event-popup">
                <button type="button" className="popup-screen-close" onClick={closePopup}><i className="ti-close"></i></button>
                <div className="px-4 text-center mb-4"><h4>Share <span className="text-primary">{eventItem.name}</span></h4></div>
                {!loading ?
                <>
                    <div className="popup-screen-content">
                        <div className="custom-scroll popup-screen-wrap has-submit">
                            {connections.length>0 ?
                            <>
                                <div className="row">
                                    {connections.map((connectionItem)=>{
                                        return(
                                            <div className="col-12" key={connectionItem.user_id}>
                                                <ShareConnectonRow 
                                                    connectionItem={connectionItem}
                                                    id={connectionItem.user_id} 
                                                    token={token} 
                                                    isSelected={selectedConnections.includes(connectionItem.user_id)} 
                                                    onCheckboxChange={handleCheckboxChange}
                                                />
                                            </div>
                                        )
                                    })}                                    
                                </div>                                
                            </>
                            :
                            <>
                                <p>There are no connections to share</p>
                            </>
                            }
                        </div>
                        {selectedConnections.length>0 &&
                            <>                                
                                <div className="popup-screen-submit-wrap w-100 position-absolute left-0 bottom-0 text-center">
                                {!shareLoading ?
                                    <button type="button" className="btn btn-primary" onClick={handleSubmit}>Share Now</button>
                                    :
                                    <button type="button" className="btn btn-primary" disabled>
                                        <svg version="1.1" id="loader-1" x="0px" y="0px" width="16px" height="16px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.5" fill="#fff" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#fff" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                                    </button>
                                }
                                </div>                                
                            </>
                        }
                        {message!==null &&
                            <div className="w-100 p-3 bg-white position-absolute left-0 bottom-0 text-center">
                                <p className="text-success fw-bold">{message}</p>
                            </div>
                        }
                    </div>
                </>
                :
                <>
                    <div className="css-loader w-100">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </>
                }
            </div>
        </div>
        </>
    )
}

export default ShareEventToConnectionPopup;