'use client';
import { useState, useEffect } from "react";
import { fetchEventAll } from "@/utils/apiActions";
import moment from "moment";
import Image from "next/image";

const ShareEventRow=(props)=>{
    const {eventItem, connection, token} = props;
    const [message, setMessage] = useState(null)
    const [shareLoading, setShareLoding] = useState(false);

    const shareEventSubmit=async()=>{
        const formdata = new FormData();
        formdata.append("event_id", eventItem.id);
        formdata.append("action", 'add');
        formdata.append("connection_ids[]", connection.user_id);
        
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setShareLoding(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/handle-sharedevents`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setShareLoding(false);
            setMessage('Shared');
        })
        .catch((error) => {
            console.error(error);
            setMessage(error);
            setShareLoding(false);
        });
    }

    return(
        <>
        {eventItem.filter_type !== 'upcoming' &&
            <div className={`share-event-card justify-content-between d-flex gap-3 p-3 mb-4 align-items-center border border-primary rounded`}>
                {eventItem?.event_photo!==null &&
                <div className="image-wrapper position-relative ratio ratio-1x1 rounded overflow-hidden">
                    <Image
                        src={eventItem?.event_photo?.preview_url}
                        alt={eventItem.name}
                        //sizes="100vw"
                        fill
                        style={{
                            objectFit: 'cover', // cover, contain, none
                        }}
                    />
                </div>
                }
                <div className="flex-grow-1">
                    <div className="event-name">{eventItem.name}</div>
                    <div className='event-meta d-flex align-items-center mb-1'><i className='ti-calendar'></i>
                        <span className='px-2'>
                            {moment(eventItem.start_date).format('DDMY')!==moment(eventItem.end_date).format('DDMY') ?
                                <>
                                {moment(eventItem.start_date).format('DD MMM,Y')} - {moment(eventItem.end_date).format('DD MMM,Y')}
                                </>
                                :
                                <>
                                    {moment(eventItem.start_date).format('DDMY')}
                                </>
                            }
                        </span>
                    </div>
                    <div className='event-meta d-flex align-items-center mb-1'><i className='ti-time'></i>
                        <span className='px-2'>
                            {moment(eventItem.start_date).format('HH:mm A')} - {moment(eventItem.end_date).format('HH:mm A')}
                        </span>
                    </div>
                    <div className='event-meta d-flex align-items-center mb-1'><i className='ti-location-pin'></i><span className='px-2'>{eventItem.event_location}</span></div>                    
                </div>
                {!shareLoading ?
                    <>
                        {message===null ?
                            <button type="button" className="btn btn-primary btn-tiny align-self-start" onClick={shareEventSubmit}>Share</button>
                        :
                            <p className="alert alert-success py-1 px-1 fs-12 align-self-start">{message}</p>
                        }
                    </>
                    :
                    <>
                        <button type="button" className="btn btn-primary btn-tiny align-self-start"><svg version="1.1" id="loader-1" x="0px" y="0px" width="16px" height="16px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.5" fill="#fff" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#fff" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg></button>
                    </>
                }
            </div>
        }
        </>
    )
}

const ShareEventPopup=(props)=>{
    const {setShowPopup, connection, token} = props;
    const [loading, setLoading] = useState(false);
    const [isMounted, setIsMounted] = useState(false);
    const [eventsList, setEventsList] = useState([]);

    const closePopup=()=>{
        setShowPopup(false);
    }

    const getEvents=async()=>{
        setLoading(true);
        const [eventsData] = await Promise.all([
            fetchEventAll("",1,-1,"upcoming"),
        ]);

        if(eventsData.status===1){
            setEventsList(eventsData.data);
        }
        setLoading(false);
    }

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getEvents();
    },[isMounted]);

    return(
        <>
        <div className="popup-screen">
            <div className="popup-screen-inner position-relative share-event-popup">
                <button type="button" className="popup-screen-close" onClick={closePopup}><i className="ti-close"></i></button>
                <div className="px-4 text-center mb-4"><h4>Share Event to <span className="text-primary">{connection.name}</span></h4></div>
                {!loading ?
                <>
                    <div className="popup-screen-content">
                        <div className="custom-scroll popup-screen-wrap">
                            {eventsList.length>0  ?
                            <>
                                <div className="row">
                                    {eventsList.map((eventitem)=>{
                                        return(
                                            <div className="col-12" key={eventitem.id}>
                                                <ShareEventRow eventItem={eventitem} connection={connection} token={token} />
                                            </div>
                                        )
                                    })}
                                </div>
                            </>
                            :
                            <>
                                <p>There are no upcoming events to share</p>
                            </>
                            }
                        </div>

                        {/*(eventsList.length>0 && selectedEvent!==null) &&
                            <div className="popup-screen-submit-wrap w-100 position-absolute left-0 bottom-0 text-center">
                                <button type="button" className="btn btn-primary" onClick={shareEventSubmit}>Share Now</button>
                            </div>
                        }
                        {message!==null &&
                            <div className="w-100 p-3 bg-white position-absolute left-0 bottom-0 text-center">
                                <p>{message}</p>
                            </div>
                        */}
                    </div>
                </>
                :
                <>
                    <div className="css-loader w-100">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </>
                }
            </div>
        </div>
        </>
    )
}

export default ShareEventPopup;