'use client';
import { useState } from "react";
import { getAuthToken } from "@/utils/auth";

const PostModal = (props) => {
    const { setShowPopup, postdata } = props;

    const closePopup = () => {
        setShowPopup(false);
    };

    return (
        <>
            <div className="popup-screen">
                <div className="popup-screen-inner p-0">
                    {!loading ?
                        <>
                            <div className="view-challanges-ui p-4">
                                <div className="d-flex align-items-center gap-2 mb-4">
                                    <img
                                    src="https://via.placeholder.com/50"
                                    alt="Brand Logo"
                                    className="rounded-pill"
                                    />
                                    <div>
                                    <h6 className="mb-0 fw-bold">Brand Name</h6>
                                    </div>
                                </div>
                                <div className="custom-scroll popup-screen-wrap overflow-y-auto h-96">
                                    <textarea
                                        className="form-control mb-2 border-0 resize-none p-0 mb-4"
                                        placeholder="Type here"
                                         rows="5"
                                    ></textarea>
                                    <button className="btn btn-primary btn-sm">Post</button>
                                </div>
                                <div className="position-absolute right-0 view-challanges-inner">
                                    <i className="ti-close" onClick={closePopup}></i>
                                </div>
                            </div>
                        </>
                        :
                        <>
                            <div className="css-loader w-100">
                                <div className="lds-ripple"><div></div><div></div></div>
                            </div>
                        </>
                    }
                </div>
            </div>
        </>
    );
}

export default PostModal;
