'use client';
import { useState } from "react";
import Image from "next/image";

const PostModal = (props) => {
    const { setShowPopup, likedata } = props;
    const [loading, setLoading] = useState(false);

    const closePopup = () => {
        setShowPopup(false);
    };

    return (
        <>
            <div className="popup-screen">
                <div className="popup-screen-inner p-0">
                    {!loading ?
                        <>
                           <div className="view-challanges-ui p-4">
                                <div className="d-flex flex-column gap-3">
                                    {likedata.likes.length && likedata.likes.map((item) => (
                                        <div key={item.id} className="d-flex align-items-center gap-2 border-bottom pb-3">
                                            <Image
                                                src={item?.photo.original_url}
                                                height={40}
                                                width={40}
                                                alt="Brand Logo"
                                                className="rounded-pill mr-3"
                                                style={{ objectFit: "cover" }}
                                            />
                                            <div>
                                                <h6 className="mb-0 fw-bold">{item.name} {item.lastname}</h6>
                                            </div>
                                        </div>
                                    ))}
                                </div>
                                <div className="position-absolute right-0 view-challanges-inner">
                                    <i className="ti-close" onClick={closePopup}></i>
                                </div>
                            </div>

                        </>
                        :
                        <>
                            <p>Error</p>
                        </>
                    }
                </div>
            </div>
        </>
    );
}

export default PostModal;
