
const PageHeader=(props)=>{
    const {title, showbreadcrumb} = props;
    return(
        <section className="page-header bg-light-gray has-shapes has-bg-brash bg-brash-bottom">
            {title !=="" &&
            <>
            <div className={`container ${title!=="" && 'h-100'}`}>
                <div className="row d-flex align-items-center h-100">
                    <div className="col-md-12 text-center">
                        <h2 className="h1 font-weight-bold">{title}</h2>
                        {showbreadcrumb &&
                            <nav className="mt-15" aria-label="breadcrumb">
                                <ol className="breadcrumb font-weight-bold bg-transparent p-0 justify-content-center">
                                    <li className="breadcrumb-item"><a href="index.html" className="text-black-300">Home</a></li>
                                    <li className="breadcrumb-item text-primary" aria-current="page">This Page</li>
                                </ol>
                            </nav>
                        }
                    </div>
                </div>
            </div>
            </>
            }
            <div className="shape-1 shape-sm bg-secondary rounded-circle d-none d-sm-block"></div>
            <div className="shape-2 shape-sm bg-primary rounded-circle d-none d-sm-block"></div>
            <div className="shape-3 shape-sm bg-tertiary rounded-circle d-none d-sm-block"></div>
            <div className="shape-4 shape-sm bg-secondary rounded-circle d-none d-sm-block"></div>
            <div className="shape-5 shape-xs bg-primary rounded-circle d-none d-sm-block"></div>
            <div className="shape-6 shape-xs-2 bg-tertiary rounded-circle d-none d-sm-block"></div>
        </section>
    )
}

export default PageHeader;