'use client'
import { useEffect } from 'react';
import Image from "next/image";
const IntegrateToolsSection = () => {

    function incircle(element, options = {}) {
        const settings = {
            color: '#556b2f',
            backgroundColor: 'white',
            type: 1, // Circle type: 1 for whole, 0.5 for half, 0.25 for quarter
            radius: '14em', // Distance from center
            start: 0, // Shift start from 0 degrees
            top: '0',
            left: '0',
            ...options
        };
    
        // Set base styles for the parent element
        element.style.position = 'relative';
        element.style.top = settings.top;
        element.style.left = settings.left;
        element.style.margin = '0';
        element.style.padding = '0';
        element.style.listStyleType = 'none';
    
        // Get all child elements except the first one
        const elements = Array.from(element.children).slice(1);
        const numberOfElements = settings.type === 1 ? elements.length : elements.length - 1;
        const slice = (360 * settings.type) / numberOfElements;
    
        elements.forEach((child, i) => {
            const rotate = slice * i + settings.start;
            const rotateReverse = rotate * -1;
    
            // Set styles for each child element
            child.style.position = 'absolute';
            child.style.transition = 'transform 1s linear';
            child.style.transform = `rotate(${rotate}deg) translate(${settings.radius}) rotate(${rotateReverse}deg)`;
        });
    }
    useEffect(() => {
        const circleElement = document.querySelector('.in-circle');
        if (circleElement) {
            incircle(circleElement, {
                radius: '13em',
                type: 1,
                start: 0,
            });
        }
    }, []);
  return (
    <section className="section-lg bg-theme-light relative">
      {/* Top SVG */}
      <Image
        src="/images/brushes/section-top.svg"
        className="absolute top-0 left-0 w-full h-6 md:h-auto"
        alt=""
        loading="lazy"
        width="732"
        height="1050"
        decoding="async"
      />

      {/* Bottom SVG */}
      <Image
        src="/images/brushes/section-bottom.svg"
        className="absolute bottom-0 left-0 w-full h-6 md:h-auto"
        alt=""
        loading="lazy"
        width="732"
        height="1050"
        decoding="async"
      />

      <div className="container">
        <div className="lg:col-11 mx-auto">
          <div className="row items-center gy-4 lg:gy-0 justify-center">
            {/* Text Content */}
            <div className="md:col-8 lg:col-4">
              <h2 className="mb-4">
                Integrate the <strong>tools you already use</strong>
              </h2>
              <p>
                Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod
                tempor invidunt ut labore et dolore magna aliquyam erat sed.
              </p>
            </div>

            {/* Rotating Circle */}
            <div className="lg:col-6 h-[300px] sm:h-[370px] lg:h-96 tools-image-section ">
            <ul className="in-circle flex items-center justify-center scale-[0.6] sm:scale-[0.8] lg:scale-100">
                <li className="w-[180px] h-[180px] bg-white flex items-center justify-center rounded-full">
                    <Image src="/images/tools/01.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="46" height="15"  />
                </li>
                <li className="w-[114px] h-[114px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/02.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="134" height="35"  /> 
                </li>
                <li className="w-[82px] h-[82px] bg-white flex items-center justify-center rounded-full" > 
                    <Image src="/images/tools/03.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="46" height="15"  />
                </li>
                <li className="w-[114px] h-[114px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/04.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="89" height="28"  />
                </li>
                <li className="w-[82px] h-[82px] bg-white flex items-center justify-center rounded-full" > 
                    <Image src="/images/tools/05.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="46" height="15"  />
                </li>
                <li className="w-[114px] h-[114px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/06.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="89" height="28"  />
                </li>
                <li className="w-[82px] h-[82px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/07.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="46" height="15"  />
                </li>
                <li className="w-[114px] h-[114px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/08.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="89" height="28"  />
                </li>
                <li className="w-[82px] h-[82px] bg-white flex items-center justify-center rounded-full"> 
                    <Image src="/images/tools/05.png" className="w-auto h-auto" alt="brand-logo" loading="lazy" width="46" height="15"  /> 
                </li>
            </ul>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default IntegrateToolsSection;
