'use client';
import { useState, useEffect } from "react";
import { fetchLatestInspiration } from "@/utils/apiActions";
import DOMPurify from 'dompurify';

const Inspiration=()=>{
    const [inspirationData, setInspirationData] = useState({});
    const [isMounted, setIsMounted] = useState(false);
    const [loading, setLoading] = useState(false);

    const getInspiration = async()=>{
        setLoading(true);
        const [response] = await Promise.all([
            fetchLatestInspiration()
        ]);
        
        setInspirationData(response.data);
        setLoading(false);
    }
    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getInspiration();
    },[isMounted]);
    return(
        <>
        {(!loading && Object.keys(inspirationData).length > 0) ? 
        <>
            <div className="col-12">
                <div className='inspiration-text' dangerouslySetInnerHTML={{ __html: DOMPurify.sanitize(inspirationData.inspiration) }} />
                <div className="flex justify-end fst-italic text-end fw-semibold">-{inspirationData.source}-</div>
            </div>
        </>
        :
        <></>
        }
        </>
    )
}

export default Inspiration;