'use client'
import React, { useState } from 'react';
// import './HowItWorksTabs.css';
import Image from "next/image";
import Link from "next/link";

const HowItWorksTabs = () => {
  const [activeTab, setActiveTab] = useState('management');

  const handleTabClick = (tab) => {
    setActiveTab(tab);
  };

  return (
    <section id="howitworks" className="section-padding how-it-works-tab pt-40 overflow-hidden">
      <div className="main-container">
        <div className="row justify-content-center">
          <div className="col-lg-6 col-md-9 text-center mb-40">
            <h2 className="section-title">Tree  <strong>During Those Times</strong></h2>
            <p>
               During Those Times was created to allow users like you and me to have a more exclusive social network dedicated to family, close friends, and those we love.
            </p>
          </div>
          <div className="col-lg-11 ">
            <div className='tab-howitworks'>
              <ul className="nav nav-pills justify-content-center mb-20">
                <li className="nav-item " role="presentation">
                  <a
                    className={`nav-link ${activeTab === 'management' ? 'active' : ''}`}
                    onClick={() => handleTabClick('management')}
                  >
                    <i className="circle-shape"></i> Share Moments
                  </a>
                </li>
                <li className="nav-item " role="presentation">
                  <a
                    className={`nav-link ${activeTab === 'chat' ? 'active' : ''}`}
                    onClick={() => handleTabClick('chat')}
                  >
                    <i className="circle-shape"></i> Built In Chat
                  </a>
                </li>
                <li className="nav-item " role="presentation">
                  <a
                    className={`nav-link ${activeTab === 'analytics' ? 'active' : ''}`}
                    onClick={() => handleTabClick('analytics')}
                  >
                    <i className="circle-shape"></i> Family Tree Builder
                  </a>
                </li>
                <li className="nav-item " role="presentation">
                  <a
                    className={`nav-link ${activeTab === 'collaboration' ? 'active' : ''}`}
                    onClick={() => handleTabClick('collaboration')}
                  >
                    <i className="circle-shape"></i> Personal Journey Support
                  </a>
                </li>
                <li className="nav-item " role="presentation">
                  <a
                    className={`nav-link ${activeTab === 'milestone' ? 'active' : ''}`}
                    onClick={() => handleTabClick('milestone')}
                  >
                    <i className="circle-shape"></i> Track Milestones
                  </a>
                </li>
              </ul>
            </div>
            <div className="tab-content" id="pills-tabContent">
              {activeTab === 'management' && (
                <div className="tab-pane fade show active">
                  <div className="row items-center justify-center gy-4 lg:gy-0">
                    <div className="lg:col-6">
                      <Image className="img-fluid rounded-lg shadow" src="/images/WaveAndSun.jpg" width={630} height={402}  alt="" />
                    </div>
                    <div className="lg:col-6 md:col-10 text-left anim-to-bottom">
                      <h2 className="section-title">&apos;Those <strong>Times&apos;</strong></h2>
                      <p className="mb-30">
                         Those moments, times that make you smile, make you proud, that make us cry, give us a place where we can be a part of each other&lsquo;s lives, sharing love and grief while extending our support.
                      </p>
                      <Link href="/dashboard/subscriptionplan" className="btn btn-primary has-icon">
                        Try Now
                        <span className="icon">
                          <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor" />
                          </svg>
                        </span>
                      </Link>
                    </div>
                  </div>
                </div>
              )}
              {activeTab === 'chat' && (
                <div className="tab-pane fade show active">
                  <div className="row items-center justify-center gy-4 lg:gy-0">
                    <div className="lg:col-6 anim-to-top">
                      <Image className="img-fluid rounded-lg shadow" src="/images/SurfBoard.jpg" width={630} height={402} alt="" />
                    </div>
                    <div className="lg:col-6 md:col-10 text-left anim-to-bottom">
                      <h2 className="section-title">Built In <strong>Chat</strong></h2>
                      <p className="mb-30">
                        *Direct Messaging to Loved Ones in your Network,
                        *Share Milestones Together,
                        *Give Virtual Gifts for the Occasion,
                        *Perform Wellness Checks.
                      </p>
                      <Link href="/dashboard/subscriptionplan" className="btn btn-primary has-icon">
                        View More
                        <span className="icon">
                          <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor" />
                          </svg>
                        </span>
                      </Link>
                    </div>
                  </div>
                </div>
              )}
              {activeTab === 'analytics' && (
                <div className="tab-pane fade show active" >
                    <div className="row items-center justify-center gy-4 lg:gy-0">
                        <div className="lg:col-6 anim-to-top">
                        <Image className="img-fluid rounded-lg shadow" src="/images/WavesAndPalmtree.jpeg" width={630} height={402} alt="" />
                        </div>
                        <div className="lg:col-6 md:col-10 text-left anim-to-bottom">
                        <h2 className="section-title">Tree Of <strong>Life</strong></h2>
                        <p className="mb-30">Enjoy the Family Tree-building feature to document your heritage and share it with other loved ones. </p>
                        <Link href="/dashboard/subscriptionplan" className="btn btn-primary has-icon">
                            View More
                            <span className="icon"><svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor" /></svg></span>
                        </Link>
                        </div>
                    </div>
                </div>
              )}
              {activeTab === 'collaboration' && (
                <div className="tab-pane fade show active" >
                    <div className="row items-center justify-center gy-4 lg:gy-0">
                    <div className="lg:col-6 anim-to-top">
                        <Image className="img-fluid rounded-lg shadow" src="/images/hero-bgX.jpg" width={630} height={402} alt=""/>
                    </div>
                    <div className="lg:col-6 md:col-10 text-left anim-to-bottom">
                        <h2 className="section-title">Community <strong>Support</strong></h2>
                        <p className="mb-30">Providing daily motivation and encouragement to those who need it. We hope this helps guide us toward self-improvement, empowers those overcoming challenges, and more.</p>
                        <a href="/dashboard/subscriptionplan" className="btn btn-primary has-icon">
                        View More
                        <span className="icon"><svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor" /></svg></span>
                        </a>
                    </div>
                    </div>
                </div>
              )}
              {activeTab === 'milestone' && (
                <div className="tab-pane fade show active" >
                    <div className="row items-center justify-center gy-4 lg:gy-0">
                    <div className="lg:col-6 anim-to-top">
                        <Image className="img-fluid rounded-lg shadow" src="/images/BeachAndWater.jpeg" width={630} height={402} alt="" />
                    </div>
                    <div className="lg:col-6 md:col-10 text-left anim-to-bottom">
                        <h2 className="section-title">Track <strong>Milestones</strong></h2>
                        <p className="mb-30">Build your wall of success. Take note of your achievements, revisit your journey, be proud of your strength, and grow mentally, physically, financially, and spiritually.</p>
                        <a href="/dashboard/subscriptionplan" className="btn btn-primary has-icon">
                        View More
                        <span className="icon"><svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor" /></svg></span>
                        </a>
                    </div>
                    </div>
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HowItWorksTabs;
