'use client'
import React from "react";
import Slider from "react-slick";
import Image from "next/image";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";

const HowItWorks = () => {
  const settings = {
    dots: false,
    infinite: true,
    speed: 500,
    slidesToShow: 6,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 2000,
    responsive: [
      { breakpoint: 1024, settings: { slidesToShow: 4 } },
      { breakpoint: 768, settings: { slidesToShow: 2 } },
      { breakpoint: 480, settings: { slidesToShow: 1 } },
    ],
  };

  const images = [
    "01-colored.png",
    "02-colored.png",
    "04-colored.png",
    "03-colored.png",
    "05-colored.png",
    "06-colored.png",
  ];

  return (
    <section id="howitworks" className="section-padding overflow-hidden">
      <div className="container">
        <Slider {...settings}>
          {images.map((src, index) => (
            <div key={index} className="d-flex align-items-center justify-content-center grayscale opacity-80 hover:opacity-100 hover:grayscale-0 transition text-center">
              <Image
                className="mx-auto w-auto h-auto"
                src={`/images/brands/${src}`}
                alt={`Brand ${index + 1}`}
                width={100}
                height={100}
              />
            </div>
          ))}
        </Slider>
      </div>
    </section>
  );
};

export default HowItWorks;
