'use client';
import React, { useState, useEffect } from "react";
import Image from "next/image"; 
import { useRouter } from "next/navigation";
import Cookies from "js-cookie";
import "./herohome.scss";

const Herohome = () => {
  const [isVideoOpen, setIsVideoOpen] = useState(false);
  const [isLoggedIn, setIsLoggedIn] = useState(false);
  const router = useRouter();

  useEffect(() => {
    const userToken = Cookies.get("auth_token");
    if (userToken) {
      setIsLoggedIn(true);
    }
  }, []);

  const handleVideoOpen = () => {
    setIsVideoOpen(true);
  };

  const handleVideoClose = () => {
    setIsVideoOpen(false);
  };

  const handleSignUpClick = () => {
    if (isLoggedIn) {
      router.push('/');
    } else {
      router.push('/auth/signup');
    }
  };

  return (
    <section className="section bg-theme-light relative hero-section"  style={{
      backgroundImage: "url('images/BoysCenter.jpeg')",
      backgroundPosition: "top, bottom", 
      backgroundRepeat: "no-repeat, no-repeat", 
      backgroundSize: "cover",
    }}>
      <Image
        src="/images/brushes/banner.svg"
        className="absolute bottom-0 left-0 w-full h-auto"
        alt=""
        loading="lazy"
        width="732"
        height="1050"
        decoding="async"
      />
      <div className="main-container">
        <div className="row gy-5 lg:gy-0 hero-main">
          <div className="lg:col-6 xl:col-5 hero-content">
            <h2 className="h1 mb-6">
              During Those Times Is A Social Platform -{' '}
              <strong>Where Real Life Happens...</strong>
            </h2>
            <p>
               Created to allow users like you and me to have a more exclusive network dedicated to Family &Close Friends should be family and close friends, prioritizing personal growth and wellness.
            </p>
            <form action="#" className="block mt-8">
              <button
                type="button"
                className="btn btn-sm btn-outline-primary w-full flex text-center space-x-2 items-center justify-center group"
                onClick={handleSignUpClick}
              >
                <span className=" text-white transition">
                  Sign up with Us
                </span>
              </button>
            </form>
          </div>
          {/* <div className="lg:col-6 xl:col-7 hero-image">
            <div className="relative text-center">
              <button
                type="button"
                className="video-play-btn"
                onClick={handleVideoOpen}
                aria-label="play-button"
              >
                <svg
                  width="1.8em"
                  height="1.8em"
                  viewBox="0 0 16 16"
                  fill="currentColor"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path d="M11.596 8.697l-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z"></path>
                </svg>
              </button>
              <Image
                src="/images/screenshots/banner-shot.png"
                className="mx-auto"
                alt="banner-img"
                loading="lazy"
                width="704"
                height="492"
                decoding="async"
              />
            </div>
          </div> */}
        </div>
      </div>
      {/* Video Modal */}
      {isVideoOpen && (
        <div className="video-modal">
          <div className="video-modal-content">
            <button className="close-btn" onClick={handleVideoClose}>
              &times;
            </button>
            <iframe
                width="100%"
                height="100%"
                src="https://www.youtube.com/embed/aqz-KE-bpKQ?autoplay=1&si=IXOoqGPuwsk9Jk79"
                title="Video"
                frameBorder="0"
                allow="autoplay; encrypted-media"
                allowFullScreen
            ></iframe>
          </div>
        </div>
      )}
    </section>
  );
};

export default Herohome;
