"use client";
import { useState, useEffect, useRef } from 'react';
import { useRouter } from "next/navigation";
import { usePathname } from 'next/navigation';
import { isUserAuthenticated, logoutUser } from '@/utils/auth';
import Image from "next/image";
import Link from "next/link";
import Logo from "../../../public/images/logo.png";
import { fetchUserDetail } from '@/utils/apiActions';

const Header = () => {
    const [isLoggedin, setIsLoggedin] = useState(false);
    const [loading, setLoading] = useState(false);
    const [showUserNavModel, setShowUserNavModel] = useState(false);
    const [currentUser, setCurrentUser] = useState({});
    const [isMounted, setIsMounted] = useState(false);
    const [isMenuOpen, setIsMenuOpen] = useState(false); // State for mobile menu toggle
    const refMenu = useRef();
    const [isScrolled, setIsScrolled] = useState(false);
    const pathname = usePathname();
    const router = useRouter();

    const handleLogout = () => {
        logoutUser();
        window.location.href = '/';
        if (isMenuOpen) {
            toggleMobileMenu(); // Close the menu when a link is clicked
        }
    };

    const handleUserNavModel = () => {
        setShowUserNavModel(!showUserNavModel);
    };

    const toggleMobileMenu = () => {
        setIsMenuOpen((prevState) => {
            const newState = !prevState;
            if (newState) {
                document.body.classList.add('menu-open'); // Add class to body
            } else {
                document.body.classList.remove('menu-open'); // Remove class from body
            }
            return newState;
        });
    };

    const handleNavClick = (href) => {
        if (router.pathname !== "/") {
            router.push(href);
        } else {
            const elementId = href.split("#")[1];
            const element = document.getElementById(elementId);
            if (element) {
                element.scrollIntoView({ behavior: "smooth" });
            }
        }
    };
    const navItems = [
        { name: 'What Is DTT ?', href: '/#howitworks' },
        { name: 'Why Join DTT ?', href: '/#whyjoin' },
        { name: 'What Do I Get?', href: '/#pricing' },
        { name: 'Need Help ?', href: '/#needhelp' },
    ];

    

    const isActive = (href) => {
        if (href === '/') {
            return pathname === href;
        }
        return pathname === href || pathname.startsWith(href);
    };

    const getUserDetail = async () => {
        setLoading(true);
        const [response] = await Promise.all([
            fetchUserDetail()
        ]);
        setCurrentUser(response.data);
        setLoading(false);
    };

    useEffect(() => {
        const checkIfClickedOutside = (e) => {
            if (showUserNavModel && refMenu.current && !refMenu.current.contains(e.target)) {
                setShowUserNavModel(false);
            }
        };
        document.addEventListener("mousedown", checkIfClickedOutside);
        return () => {
            document.removeEventListener("mousedown", checkIfClickedOutside);
        };
    }, [showUserNavModel]);

    useEffect(() => {
        setIsLoggedin(isUserAuthenticated());
    }, []);

    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        if (isLoggedin) {
            getUserDetail();
        }
    }, [isMounted]);
    const closeMenuOnLinkClick = () => {
        if (isMenuOpen) {
            toggleMobileMenu(); // Close the menu when a link is clicked
        }
    };
    useEffect(() => {
        const handleScroll = () => {
          setIsScrolled(window.scrollY > 80); // Adjust threshold as needed
        };
    
        window.addEventListener("scroll", handleScroll);
        return () => {
          window.removeEventListener("scroll", handleScroll);
        };
      }, []);
    return (
        <>
       
            <header className={`header-nav position-relative bg-light-gray has-shapes has-bg-brash bg-brash-bottom ${
                isScrolled ? "scrolled" : ""
              }`}>
                <div className="container">
                    <nav className="navbar navbar-expand-xl navbar-light px-0">
                        <Link className="navbar-brand p-0" href={'#'} onClick={() => window.location.href = '/'}>
                            <Image src={Logo} width={100} height={100} alt="During Those Time" priority />
                        </Link>

                        <button
                            className={`navbar-toggler bg-white rounded-0 p-0  ${
                                isMenuOpen ? "active" : ""
                            }`}
                            type="button"
                            onClick={toggleMobileMenu} // Use React state to toggle menu
                        >
                            <svg className="nav-toggle-icon fill-current text-gray-700" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="40">
                                <path className="line top" d="m 70,33 h -40 c 0,0 -8.5,-0.149796 -8.5,8.5 0,8.649796 8.5,8.5 8.5,8.5 h 20 v -20" />
                                <path className="line middle" d="m 70,50 h -40" />
                                <path className="line bottom" d="m 30,67 h 40 c 0,0 8.5,0.149796 8.5,-8.5 0,-8.649796 -8.5,-8.5 -8.5,-8.5 h -20 v 20" />
                            </svg>

                           
                        </button>

                        <div className={`collapse navbar-collapse ${isMenuOpen ? 'show' : ''}`} id="navlinks">
                            <ul className='navbar-nav mx-auto'>
                                <li className='nav-item'><Link className="nav-link" href="/#howitworks" onClick={() => window.location.href = '/#howitworks'}>What Is DTT ?</Link></li>
                                <li className='nav-item'><Link className="nav-link" href="/#whyjoin" onClick={() => window.location.href = '/#whyjoin'}>Why Join DTT ?</Link></li>
                                <li className='nav-item'><Link className="nav-link" href="/#pricing" onClick={() => window.location.href = '/#pricing'}>What Do I Get?</Link></li>
                                <li className='nav-item'><Link className="nav-link" href="/#needhelp" onClick={() => window.location.href = '/#needhelp'}>Need Help ?</Link></li>
                            </ul>
                            {/* <ul className="navbar-nav mx-auto">
                                {navItems.map((item, index) => (
                                    <li key={index} className={`nav-item ${isActive(item.href) ? 'active' : ''}`}>
                                        <Link className="nav-link" href={item.href} onClick={() => handleNavClick(item.href)}>{item.name}</Link>
                                    </li>
                                ))}
                               
                            </ul> */}
                            <div className="navbar-button">
                                {!isLoggedin && (
                                    <Link  href="/auth/signup"
                                    onClick={closeMenuOnLinkClick} className="btn btn-sm btn-outline-primary"
                                    >
                                        Sign Up
                                    </Link>
                                )}
                            </div>
                            
                            <div className="navbar-button position-relative nav-item" ref={refMenu}>
                                {(!loading && !isLoggedin) ?
                                    <>
                                        <Link href="/auth/login" onClick={closeMenuOnLinkClick} className="text-white nav-link pr-xl-0 flex">
                                            Log in
                                            <svg width="1.5em" height="1.5em" viewBox="0 0 16 16" className="bi bi-arrow-right-short" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                                <path fillRule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                                            </svg>
                                        </Link>
                                    </>
                                    :
                                    <>
                                        
                                        {(!loading && Object.keys(currentUser).length > 0) &&
                                            <>
                                                <div className='d-block col-12 d-lg-none'>
                                                    <div className='d-flex nav-item ps-0'>
                                                        <Link href={`/dashboard`} onClick={closeMenuOnLinkClick} type='button' className='nav-link btn-outline-primary text-decoration-none '>Dashboard</Link>
                                                    </div>
                                                    <div className='d-flex flex-column align-items-start nav-item ps-0'>
                                                        {/* <Link href={`/dashboard/profile/edit`} onClick={closeMenuOnLinkClick} className="nav-link py-0 px-0 text-decoration-none btn-link ">Edit Profile</Link> */}
                                                        <Link href={`/dashboard/profile/change-password`} onClick={closeMenuOnLinkClick} className="nav-link py-0 px-0 text-decoration-none btn-link ">Change Password</Link>
                                                        <button onClick={handleLogout}  className="nav-link py-0 px-0 text-decoration-none btn-link">Logout</button>
                                                    </div>
                                                </div>
                                                <button type="button" onClick={handleUserNavModel} className="btn btn-sm btn-outline-primary d-none d-md-flex align-items-center">
                                                    Hi, {`${currentUser.firstname} ${currentUser.lastname}`}<i className='ti-angle-down ms-2'></i>
                                                </button>
                                                <div className={`nav-user-modal ${showUserNavModel && 'active'}`}>
                                                    <div className='border-bottom border-gray pb-3 mb-3'>
                                                        <div className='d-flex align-items-center mb-3'>
                                                            <div className="profile-image overflow-hidden rounded-circle">
                                                                {currentUser.photo !== null ?
                                                                    <>
                                                                        <Image src={currentUser.photo.thumbnail} width={50} height={50} alt="During Those Time" priority />
                                                                    </>
                                                                    :
                                                                    <>
                                                                        <i className="ti-user"></i>
                                                                    </>
                                                                }
                                                            </div>
                                                            <div className='fw-bold flex-grow-1 ps-3'>{`${currentUser.firstname} ${currentUser.lastname}`}</div>
                                                        </div>
                                                        <div className='d-flex justify-content-center'>
                                                            <Link href={`/dashboard`} onClick={closeMenuOnLinkClick} type='button' className='btn btn-tiny mx-auto btn-outline-primary text-decoration-none text-uppercase'>Dashboard</Link>
                                                        </div>
                                                    </div>
                                                    <div className='d-flex flex-column align-items-start'>
                                                        <Link href={`/dashboard/profile/edit`} onClick={closeMenuOnLinkClick} className="btn py-0 px-0 text-decoration-none btn-link mb-2">Edit Profile</Link>
                                                        <Link href={`/dashboard/profile/change-password`} onClick={closeMenuOnLinkClick} className="btn py-0 px-0 text-decoration-none btn-link mb-2">Change Password</Link>
                                                        <Link href={`/dashboard/mytransactions`} onClick={closeMenuOnLinkClick} className="btn py-0 px-0 text-decoration-none btn-link mb-2">My Transactions</Link>
                                                        <button onClick={handleLogout}  className="btn py-0 px-0 text-decoration-none btn-link">Logout</button>
                                                    </div>
                                                </div>
                                            </>
                                        }
                                    </>
                                }
                                
                            </div>
                        </div>
                    </nav>
                </div>
            </header>
        </>
    );
};

export default Header;


