"use client";
const InputField = ({register, errors, fieldType, fieldName, fieldId, required, onFieldChange, labelText, labelClass, hideLabel, fieldClass, placeHolder, disabled, autoComplete, readOnly})=>{
    // Render all HTML components:
    const handleOnchange=(e)=>{
        onFieldChange(e);
    }
    
    return (
        <>
            {!hideLabel &&
                <label htmlFor={fieldId} className={labelClass}>{labelText}{required && <sup>*</sup>}</label>
            }
            <input
                {...register(fieldName)}
                type={fieldType}
                name={fieldName}
                id={fieldId}
                onChange={handleOnchange}
                className={`${fieldClass}`}
                placeholder={placeHolder}
                aria-invalid={errors.name ? "true" : "false"}
                disabled={disabled}
                autoComplete={autoComplete}
                readOnly={readOnly}
            />

            {errors && errors[fieldName]?.message && (
                <p className='font-weight-bold d-block invalid-feedback'>{errors[fieldName]?.message}</p>
            )}
        </>
    )
}

export default InputField;