"use client";

import { useState } from "react";
import { useRouter } from "next/navigation";
import { useForm } from "react-hook-form";
import * as yup from 'yup';
import InputField from "@/components/FormFields/InputField";
import { yupResolver } from '@hookform/resolvers/yup';

const schema = yup.object({
    email: yup.string().email('Invalid Email').required('Please Enter your email').matches(/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/, "Invalid Email"),    
}).required();

const ForgotPasswordForm=()=>{
    const [loading, setLoading] = useState(false);
    const [errorMessage, setErrorMessage] = useState(null);
    const [successMessage, setSuccessMessage] = useState(null);
    const router = useRouter();
    const { register, handleSubmit, formState: { errors } } = useForm({
        resolver: yupResolver(schema)
    });
    
    const onSubmit = async (data) => {
        setErrorMessage(null);
        setSuccessMessage(null);
        setLoading(true);
    
        // Prepare form data
        const formData = new FormData();
        formData.append("email", data.email);
    
        // Make the fetch request
        const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/forgot-password`, {
            method: "POST",
            body: formData,
        });    
        setLoading(false);
        const result = await response.json();        
        if (result.status === 1) {
            //router.push('/auth/login');
            setSuccessMessage(result.message);
        } else {
            setErrorMessage(result.message);
        }
    };
    return(
        <>
        <section className="login-form-section">
            <div className="container">
                <div className="login-form shadow rounded bg-white mx-auto p-3 p-sm-4">
                    {errorMessage!==null &&
                        <div className="alert alert-danger" role="alert">{errorMessage}</div>
                    }
                    {successMessage!==null &&
                        <div className="alert alert-success" role="alert">{successMessage}</div>
                    }
                    <form onSubmit={handleSubmit(onSubmit)} className={`row`}>
                        <div className="form-group mb-20 col-12">
                            <InputField
                                register={register}
                                disabled={loading}
                                fieldClass={'form-control shadow-none'}
                                hideLabel={false}
                                labelClass={'text-black-200 h6 font-weight-600 mb-2'}
                                labelText={'Email Address:'}
                                placeHolder={'Email Address'}
                                onFieldChange={(e)=>{}}
                                required={true}
                                errors={errors}
                                fieldType={"text"}
                                fieldId={"email"}
                                fieldName={'email'}
                                autoComplete={""}
                            />
                        </div>
                        <div className="form-group col-12">
                        {!loading ?
                            <button className="btn btn-primary w-100" type="submit">Submit</button>
                            :
                            <div className="btn btn-primary w-100">Updating...</div>
                        }
                        </div>
                    </form>
                </div>
            </div>
        </section>
        </>
    )
}

export default ForgotPasswordForm;