'use client'
import { useState } from 'react';
import Image from "next/image";
import Link from "next/link";
import {fetchNewsletters} from '@/utils/apiActions';

const Footer=()=>{
  const [email, setEmail] = useState('');
  const [error, setError] = useState('');
  const [success, setSuccess] = useState('');
  const [loading, setLoading] = useState(false);

  const validateEmail = (email) => {
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setError('');
    setSuccess('');
    if (!email) {
      setError('Email is required.');
      return;
    }
    if (!validateEmail(email)) {
      setError('Please enter a valid email address.');
      return;
    }
    setLoading(true);
    try {
      const response = await fetchNewsletters(email);
      if (response.status !== 0) {
        setEmail('');
        setSuccess(response.message);
        setTimeout(() => {
          setSuccess('');
        }, 3000);
      } else {
        setError(response.message);
      }
    } catch (err) {
      console.error('Fetch error:', err);
      setError('Something went wrong. Please try again later.');
    } finally {
      setLoading(false);
    }
  };
  return(
  <>
  <footer className="bg-light-gray has-shapes has-bg-brash bg-brash-top" style={{ backgroundImage: 'url(/images/brushes/footer.svg)' }}>
    <div className="container footer-top">
      <div className="row justify-content-center">
        <div className="col-lg-7 col-md-12">
          <div className="text-center pb-60">
            <h2 className="section-title footer-top-title">Join thousands of members <strong>and begin sharing moments today!</strong></h2>
            <Link href={"/auth/signup"} className="btn btn-primary has-icon">
              Get Started With Us
              <span className="icon">
                <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M12.5522 6.66669L20.5522 14.6667C21.0329 15.1473 21.0699 15.9036 20.6632 16.4267L20.5522 16.5523L12.5522 24.5523L10.6666 22.6667L17.7228 15.6095L10.6666 8.55231L12.5522 6.66669Z" fill="currentColor"></path>
                </svg>
              </span>
            </Link>
          </div>
        </div>
        <div className="col-12">
          <div className="border-bottom"></div>
        </div>
      </div>
      <div className="pt-60 pb-60 footer-detail-section">
        <div className="col-lg-4 col-md-6">
          <div className="pr-0 pr-lg-4">
            <Image className="mb-25" src="/images/logo.png" width={150} height={144} alt="" />
            <p>During Those Times is a hub to privately share important/special moments that have shaped our lives. Sharing and Reminding those that are closest to you of the most important times in our lives.</p>
          </div>
        </div>
        <div className="col-lg-2 col-md col-sm-6">
          <div className="pl-0 pl-md-3 mt-5 mt-md-0">
            <h5 className="font-weight-600 mb-20">Quick Links</h5>
            <ul className="list-unstyled footer-links">
              <li><Link href={"#"}>Join Today</Link></li>
              <li><Link href={"/#howitworks"}>Why DTT</Link></li>
              <li><Link href={"/#pricing"}>Pricing</Link></li>
              <li><Link href={"/terms-of-use"}>Terms of Use</Link></li>
              <li><Link href={"/privacy-policy"}>Privacy Policy</Link></li>
            </ul>
          </div>
        </div>
        <div className="col-lg-2 col-md col-sm-6">
          <div className="pl-0 pl-md-3 mt-5 mt-md-0">
            <h5 className="font-weight-600 mb-20">Social Links</h5>
            <ul className="list-unstyled footer-links">
              <li><Link href={"https://www.facebook.com/profile.php?id=100089886256937&mibextid=ZbWKwL"} passHref>Facebook</Link></li>
              <li><Link href={"https://www.instagram.com/dtt_app/"} passHref>Instagram</Link></li>
              <li><Link href={"https://twitter.com/DuringTTimes"} passHref>X</Link></li>
              <li><Link href={"https://www.reddit.com/user/DuringThoseTimes"} passHref>Reddit</Link></li>
            </ul>
          </div>
        </div>
        <div className="col-lg-4 col-md-6">
          <div className="pl-0 pl-lg-4 mt-5 mt-lg-0">
            <h5 className="font-weight-600">Lets Subscribe Your Email</h5>
              <form onSubmit={handleSubmit} className="needs-validation mt-30" noValidate>
                <div className="d-flex lg:max-w-[342px]">
                  <input 
                      type="email" 
                      className="form-control bg-gray" 
                      placeholder="Your email address" 
                      value={email}
                      onChange={(e) => setEmail(e.target.value)}
                      required 
                  />
                  <button type="submit" className="btn btn-primary rounded-0">
                    <svg width="31" height="16" viewBox="0 0 31 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M30.7071 8.70808C31.0976 8.31756 31.0976 7.68439 30.7071 7.29387L24.3431 0.929909C23.9526 0.539384 23.3195 0.539384 22.9289 0.929909C22.5384 1.32043 22.5384 1.9536 22.9289 2.34412L28.5858 8.00098L22.9289 13.6578C22.5384 14.0484 22.5384 14.6815 22.9289 15.072C23.3195 15.4626 23.9526 15.4626 24.3431 15.072L30.7071 8.70808ZM0 9.00098H30V7.00098H0V9.00098Z" fill="white"></path>
                    </svg>
                  </button>
              </div>
              {error && <p className="text-red-500 text-sm mt-2">{error}</p>}
              {success && <p className="text-success text-sm mt-2">{success}</p>}
            </form>
          </div>
        </div>
      </div>
    </div>
    <div className="footer-bottom">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="block border-top text-center content">
              Copyright © {new Date().getFullYear()} All Rights Reserved Gwayne Innovations, LLC
            </div>
          </div>
        </div>
      </div>
    </div>
    <div className="shape-1 shape-xs bg-primary rounded-circle"></div>
    <div className="shape-2 shape-sm-2 bg-tertiary rounded-circle"></div>
    <div className="shape-3 shape-sm bg-secondary rounded-circle"></div>
    <div className="shape-4 shape-xs-2 bg-tertiary rounded-circle"></div>
    <div className="shape-5 shape-sm-2 bg-secondary rounded-circle"></div>
    <div className="shape-6 shape-sm-2 bg-primary rounded-circle"></div>
  </footer>
  </>
  )
}
export default Footer;