'use client';

import { useEffect, useRef, useState } from 'react';
import { CKEditor } from '@ckeditor/ckeditor5-react';
import ClassicEditor from '@ckeditor/ckeditor5-build-classic';
/*import dynamic from 'next/dynamic';
const CKEditor = dynamic(() => import('@ckeditor/ckeditor5-react'), { ssr: false });
const ClassicEditor = dynamic(() => import('@ckeditor/ckeditor5-build-classic'), { ssr: false });
*/
import '../../../node_modules/ckeditor5/dist/ckeditor5.css';

const DTTEditor = ({ value, onChange }) => {
  const editorRef = useRef();
  const [isClient, setIsClient] = useState(false);

  useEffect(() => {
    setIsClient(true);
  }, []);
  useEffect(() => {
    if (editorRef.current) {
      editorRef.current.editor.setData(value);
    }
  }, [value]);

  if (!isClient) {
    return null;
  }

  return (
    <div>
      <CKEditor
        editor={ClassicEditor}
        data={value}
        onChange={(event, editor) => {
          const data = editor.getData();
          onChange(data);
        }}
        
      />
    </div>
  );
};

export default DTTEditor;