import { useState, useEffect, useRef } from "react";
import { useRouter } from "next/navigation";
import { useDropzone } from "react-dropzone";
import Image from "next/image";
//import * as yup from 'yup';
import 'rsuite/dist/rsuite.min.css';
//import InputField from "@/components/FormFields/InputField";
import { getAuthToken } from "@/utils/auth";
import { useForm } from "react-hook-form";

const CreatePost = (props) => {
    const {setIsVisible, isVisible} = props;
    const [keepsakers, setKeepsakers] = useState({});
    const [loading, setLoading] = useState(false);
    const [submitLoading, setSubmitLoading] = useState(false);
    const [errorMessage, setErrorMessage] = useState(null);
    const [fileError, setFileError] = useState(null);
    const [files, setFiles] = useState([]);
    const router = useRouter();
    const [isMounted, setIsMounted] = useState(false);
    const [postContent, setPostContent] = useState(""); // Track post content

    const { register, handleSubmit, setValue, formState: { errors } } = useForm();
    const token = getAuthToken();

    const addChallangeSubmit = async () => {
        setErrorMessage(null);
        if(postContent==="" || postContent===null){
            setErrorMessage('Enter Post Content');
            return;
        }
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);
        const formdata = new FormData();
        formdata.append("post", postContent);

        if (files.length > 0) {
            formdata.append("photo", files[0].file);
        }
        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };

        setSubmitLoading(true);

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/announcments`, requestOptions)
            .then((response) => response.text())
            .then((result) => {
                let rdata = JSON.parse(result);
                setSubmitLoading(false);
                window.location.href = "/dashboard";
            })
            .catch((error) => {
                setSubmitLoading(false);
                setErrorMessage(error);
            });
    };

    const onSubmit = async (data) => {
        addChallangeSubmit(data);
    };

    const { isDragActive, getRootProps, getInputProps, open } = useDropzone({
        noClick: true,
        noKeyboard: true,
        accept: {
            'image/*': ['.png', '.jpeg', '.jpg', '.gif', '.webp'],
        },
        maxFiles: 1,
        onDrop: acceptedFiles => {
            let tmpFiles = files;
            acceptedFiles.map((file) => {
                let tmpObj = {};
                tmpObj.file = file;
                tmpObj.preview = URL.createObjectURL(file);
                tmpObj.size = file.size;
                tmpObj.type = file.type;
                tmpObj.name = file.name;
                tmpFiles.push(tmpObj);
            });
            setFiles(tmpFiles);
        },
        onDropRejected: (rejections) => {
            setFileError('File rejected: ' + rejections);
        },
    });

    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
    }, [isMounted]);

    const isSubmitEnabled = postContent.trim().length > 0 || files.length > 0;
    
    const divRef = useRef(null);
    const [content, setContent] = useState('');
    const [isFocused, setIsFocused] = useState(false);

    
    useEffect(() => {
        if (divRef.current) {
            divRef.current.style.height = 'auto';
            divRef.current.style.height = `${divRef.current.scrollHeight}px`;
        }
    }, [content]);

    const handleFocus = () => {
        setIsFocused(true);
    };

    const handleBlur = () => {
        setIsFocused(false);
    };

    const handleChange = (e) => {
        setContent(e.target.innerText);
        setPostContent(e.target.innerText); 
    };
    return(
        <>
        {!loading &&
            <div className="event-form-section mb-3">
                <div className="event-form shadow rounded bg-white mx-auto p-3 p-sm-4">
                    <form onSubmit={handleSubmit(onSubmit)} >
                        <div className="row">
                            <div className="form-group mb-20 col-12">
                                <label className="text-black-200 h6 font-weight-600 mb-2">Post:</label>
                                {/* <InputField
                                    register={register}
                                    disabled={loading}
                                    fieldClass={'form-control shadow-none'}
                                    hideLabel={false}
                                    labelClass={'text-black-200 h6 font-weight-600 mb-2'}
                                    labelText={'Post:'}
                                    placeHolder={'Post'}
                                    onFieldChange={(e) => setPostContent(e.target.value)}
                                    required={true}
                                    errors={errors}
                                    fieldType={"text"}
                                    fieldId={"post"}
                                    fieldName={'post'}
                                    autoComplete={""}
                                />  */}


                                <div
                                    autoComplete={""}
                                    ref={divRef}
                                    contentEditable
                                    suppressContentEditableWarning
                                    className="col-11"
                                    onFocus={handleFocus}
                                    onBlur={handleBlur}
                                    onInput={handleChange}
                                    style={{
                                        border: '1px solid #ccc',
                                        padding: '8px',
                                        width: '100%',
                                        position: 'relative',
                                        backgroundColor: content === '' && !isFocused ? '#fff' : 'white',
                                        minHeight: '40px', 
                                        resize: 'none', 
                                        overflow: 'hidden', 
                                        whiteSpace: 'pre-wrap', 
                                        wordWrap: 'break-word', 
                                    }}
                                >
                                </div>
                            </div>
                            <div className="form-group mb-20 col-12 col-md-12">
                                <label className="text-black-200 h6 font-weight-600 mb-2">Photo:</label>
                                {files.length <= 0 ? 
                                    <div {...getRootProps({ className: `file-dropper` })}>
                                        <input {...getInputProps()} />
                                        <div className={`file-dropper-inner`} onClick={open}>
                                            <>
                                                {keepsakers.length > 0 &&
                                                    keepsakers.photo && keepsakers?.photo?.preview_url && keepsakers.photo.preview_url ? (
                                                        <Image
                                                            src={keepsakers.photo.preview_url}
                                                            alt="Uploaded Image"
                                                            width={200}
                                                            height={200}
                                                            className="mb-2"
                                                            style={{ objectFit: 'cover' }}
                                                        />
                                                    ) : (
                                                        <svg className="mb-2" width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <g opacity="0.8">
                                                                <path d="M57 15V57H15V15H57ZM57 9H15C11.7 9 9 11.7 9 15V57C9 60.3 11.7 63 15 63H57C60.3 63 63 60.3 63 57V15C63 11.7 60.3 9 57 9ZM42.42 35.58L33.42 47.19L27 39.42L18 51H54L42.42 35.58Z" fill="#FF3158" />
                                                            </g>
                                                        </svg>
                                                    )}

                                                {isDragActive ? (
                                                    <p>Drop the image here...</p>
                                                ) : (
                                                    <p>Drag Images Here Or <span type="button" className="text-primary">Browse</span></p>
                                                )}
                                                {fileError !== null && <p className='font-weight-bold d-block invalid-feedback'>{fileError}</p>}
                                            </>
                                        </div>
                                    </div>
                                    :
                                    <div className="file-dropper">
                                        <div className="file-dropper-inner has-preview position-relative">
                                            <Image src={files[0].preview} alt="Uploaded Preview" width={200} height={200} className="mb-2" />
                                            <button type="button" className="btn btn-primary mx-auto" onClick={() => { setFiles([]) }}>Cancel</button>
                                        </div>
                                    </div>
                                }
                            </div>
                        </div>
                        <div className="form-group col-12 text-end">
                            <button
                                className="btn btn-primary text-white px-3 py-2"
                                type="submit"
                                disabled={!isSubmitEnabled || submitLoading}
                            >
                                {submitLoading ? 'Updating...' : 'Create Post'}
                            </button>
                            <button
                                type="button"
                                className="btn btn-primary px-3 py-2 ms-2 data-action-cta data-action-cta-text shadow-sm"
                                onClick={() => setIsVisible(false)}
                            >
                                Close
                            </button>
                        </div>
                    </form>
                    {errorMessage!==null &&
                        <div className="alert alert-danger mt-3" role="alert">{errorMessage}</div>
                    }
                </div>
            </div>
        }
        </>
    )
};

export default CreatePost;
