'use client'
import React, { useState, useEffect, useRef } from "react";

const Counter = ({ count, suffix }) => {
  const [counter, setCounter] = useState(0);
  const [isInView, setIsInView] = useState(false);
  const counterRef = useRef(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsInView(true); // Start the counter when the section is in view
        }
      },
      { threshold: 0.5 } // Trigger when 50% of the section is in view
    );

    if (counterRef.current) {
      observer.observe(counterRef.current);
    }

    return () => {
      if (counterRef.current) {
        observer.unobserve(counterRef.current);
      }
    };
  }, []);

  useEffect(() => {
    if (isInView) {
      let start = 0;
      const end = parseInt(count.replace(/[^\d]/g, ''), 10); // Strip non-numeric characters (like +)
      const duration = 2000; // Time for counting animation (in milliseconds)
      const increment = end / (duration / 50); // Increment value every 50ms

      const interval = setInterval(() => {
        start += increment;
        if (start >= end) {
          setCounter(end);
          clearInterval(interval);
        } else {
          setCounter(Math.floor(start));
        }
      }, 50);
    }
  }, [isInView, count]);

  return (
    <h2 ref={counterRef} className="mb-2.5 min-h-[48px]">
      <span>{counter}</span>
      {suffix && <span>{suffix}</span>}
    </h2>
  );
};

const Countericon = () => {
  return (
    <section id="whyjoin" className="section section-padding image-info-section has-shapes bg-light-gray has-bg-brash bg-brash-y"  style={{
        backgroundImage: "url('images/brushes/section-top.svg'), url('images/brushes/section-bottom.svg')",
        backgroundPosition: "top, bottom", 
        backgroundRepeat: "no-repeat, no-repeat", 
        backgroundSize: "contain, contain",
      }}>
        <div className="container">
            <div className="row gy-5 lg:gy-0 items-center py-10">
                <div className="lg:col-6">
                    <div className="row">
                    <div className="md:col-6 lg:col-12">
                        <h2 className="mb-3.5 ">Depression can happen to anyone. <strong>People who have lived through abuse, severe losses or other stressful events are more likely to develop depression.</strong></h2>
                        <p className="pb-8 lg:border-b lg:border-b-border/80">Self-care can play an important role in managing symptoms of depression and promoting overall well-being.</p>
                    </div>
                    <div className="md:col-6 lg:col-12">
                        <div className="counter-list w-full">
                            <div className="inline-block text-center">
                                <Counter count="28M" suffix="+" />
                                <p className="text-black">In the world have depression</p>
                            </div>
                            <div className="inline-block text-center">
                                <Counter count="700K" suffix="+" />
                                <p className="text-black">Die due to suicide every year.</p>
                            </div>
                            <div className="inline-block text-center">
                                <Counter count="75" suffix="%" />
                                <p className="text-black">Of people receive NO care.</p>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
                <div className="lg:col-6">
                    <div className="row g-4 colored-icons">
                    <div className="sm:col-6">
                        <div data-aos="fade-up" data-aos-delay="0" className="icon-box h-full bg-whtie shadow px-8 py-10 text-center rounded aos-init aos-animate">
                            <astro-island uid="2sUQly" prefix="r5" component-url="/_astro/DynamicIcon.DV1TFLYb.js" component-export="default" renderer-url="/_astro/client.DEOsKY7M.js" props="{&quot;classNameName&quot;:[0,&quot;w-14 h-14 inline-block mb-6&quot;],&quot;icon&quot;:[0,&quot;FaRegThumbsUp&quot;]}" client="load" opts="{&quot;name&quot;:&quot;DynamicIcon&quot;,&quot;value&quot;:true}" await-children="">
                                <svg stroke="currentColor" fill="currentColor" strokeWidth="0" viewBox="0 0 512 512" className="w-14 h-14 inline-block mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M323.8 34.8c-38.2-10.9-78.1 11.2-89 49.4l-5.7 20c-3.7 13-10.4 25-19.5 35l-51.3 56.4c-8.9 9.8-8.2 25 1.6 33.9s25 8.2 33.9-1.6l51.3-56.4c14.1-15.5 24.4-34 30.1-54.1l5.7-20c3.6-12.7 16.9-20.1 29.7-16.5s20.1 16.9 16.5 29.7l-5.7 20c-5.7 19.9-14.7 38.7-26.6 55.5c-5.2 7.3-5.8 16.9-1.7 24.9s12.3 13 21.3 13L448 224c8.8 0 16 7.2 16 16c0 6.8-4.3 12.7-10.4 15c-7.4 2.8-13 9-14.9 16.7s.1 15.8 5.3 21.7c2.5 2.8 4 6.5 4 10.6c0 7.8-5.6 14.3-13 15.7c-8.2 1.6-15.1 7.3-18 15.2s-1.6 16.7 3.6 23.3c2.1 2.7 3.4 6.1 3.4 9.9c0 6.7-4.2 12.6-10.2 14.9c-11.5 4.5-17.7 16.9-14.4 28.8c.4 1.3 .6 2.8 .6 4.3c0 8.8-7.2 16-16 16H286.5c-12.6 0-25-3.7-35.5-10.7l-61.7-41.1c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3l61.7 41.1c18.4 12.3 40 18.8 62.1 18.8H384c34.7 0 62.9-27.6 64-62c14.6-11.7 24-29.7 24-50c0-4.5-.5-8.8-1.3-13c15.4-11.7 25.3-30.2 25.3-51c0-6.5-1-12.8-2.8-18.7C504.8 273.7 512 257.7 512 240c0-35.3-28.6-64-64-64l-92.3 0c4.7-10.4 8.7-21.2 11.8-32.2l5.7-20c10.9-38.2-11.2-78.1-49.4-89zM32 192c-17.7 0-32 14.3-32 32V448c0 17.7 14.3 32 32 32H96c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H32z"></path>
                                </svg>
                            </astro-island>
                            <h3 className="leading-8 h5">Benefit of Wellness Checks</h3>
                        </div>
                    </div>
                    <div className="sm:col-6">
                        <div data-aos="fade-up" data-aos-delay="100" className="icon-box h-full bg-whtie shadow px-8 py-10 text-center rounded aos-init aos-animate">
                            <astro-island uid="Z2qCprD" prefix="r6" component-url="/_astro/DynamicIcon.DV1TFLYb.js" component-export="default" renderer-url="/_astro/client.DEOsKY7M.js" props="{&quot;classNameName&quot;:[0,&quot;w-14 h-14 inline-block mb-6&quot;],&quot;icon&quot;:[0,&quot;FaRegCommentDots&quot;]}" client="load" opts="{&quot;name&quot;:&quot;DynamicIcon&quot;,&quot;value&quot;:true}" await-children="">
                                <svg stroke="currentColor" fill="currentColor" strokeWidth="0" viewBox="0 0 512 512" className="w-14 h-14 inline-block mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M168.2 384.9c-15-5.4-31.7-3.1-44.6 6.4c-8.2 6-22.3 14.8-39.4 22.7c5.6-14.7 9.9-31.3 11.3-49.4c1-12.9-3.3-25.7-11.8-35.5C60.4 302.8 48 272 48 240c0-79.5 83.3-160 208-160s208 80.5 208 160s-83.3 160-208 160c-31.6 0-61.3-5.5-87.8-15.1zM26.3 423.8c-1.6 2.7-3.3 5.4-5.1 8.1l-.3 .5c-1.6 2.3-3.2 4.6-4.8 6.9c-3.5 4.7-7.3 9.3-11.3 13.5c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c5.1 0 10.2-.3 15.3-.8l.7-.1c4.4-.5 8.8-1.1 13.2-1.9c.8-.1 1.6-.3 2.4-.5c17.8-3.5 34.9-9.5 50.1-16.1c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9zM144 272a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm144-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm80 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"></path>
                                </svg>
                            </astro-island>
                            <h3 className="leading-8 h5">Uplifting Communication</h3>
                        </div>
                    </div>
                    <div className="sm:col-6">
                        <div data-aos="fade-up" data-aos-delay="200" className="icon-box h-full bg-whtie shadow px-8 py-10 text-center rounded aos-init aos-animate">
                            <astro-island uid="ZrCIwr" prefix="r7" component-url="/_astro/DynamicIcon.DV1TFLYb.js" component-export="default" renderer-url="/_astro/client.DEOsKY7M.js" props="{&quot;classNameName&quot;:[0,&quot;w-14 h-14 inline-block mb-6&quot;],&quot;icon&quot;:[0,&quot;FaFilm&quot;]}" client="load" opts="{&quot;name&quot;:&quot;DynamicIcon&quot;,&quot;value&quot;:true}" await-children="">
                                <svg stroke="currentColor" fill="currentColor" strokeWidth="0" viewBox="0 0 512 512" className="w-14 h-14 inline-block mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM48 368v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H416zM48 240v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H416zM48 112v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H416zM160 128v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H192c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32H192z"></path>
                                </svg>
                            </astro-island>
                            <h3 className="leading-8 h5">Benefit Time Balancing</h3>
                        </div>
                    </div>
                    <div className="sm:col-6">
                        <div data-aos="fade-up" data-aos-delay="300" className="icon-box h-full bg-whtie shadow px-8 py-10 text-center rounded aos-init aos-animate">
                            <astro-island uid="ZTlyKT" prefix="r8" component-url="/_astro/DynamicIcon.DV1TFLYb.js" component-export="default" renderer-url="/_astro/client.DEOsKY7M.js" props="{&quot;classNameName&quot;:[0,&quot;w-14 h-14 inline-block mb-6&quot;],&quot;icon&quot;:[0,&quot;FaShieldHalved&quot;]}" client="load" opts="{&quot;name&quot;:&quot;DynamicIcon&quot;,&quot;value&quot;:true}" await-children="">
                                <svg stroke="currentColor" fill="currentColor" strokeWidth="0" viewBox="0 0 512 512" className="w-14 h-14 inline-block mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M256 0c4.6 0 9.2 1 13.4 2.9L457.7 82.8c22 9.3 38.4 31 38.3 57.2c-.5 99.2-41.3 280.7-213.6 363.2c-16.7 8-36.1 8-52.8 0C57.3 420.7 16.5 239.2 16 140c-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256 0zm0 66.8V444.8C394 378 431.1 230.1 432 141.4L256 66.8l0 0z"></path>
                                </svg>
                            </astro-island>
                            <h3 className="leading-8 h5">Strengthened Outcome</h3>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <div className="shape-3 shape-xs-2 bg-secondary rounded-circle"></div>
        <div className="shape-4 shape-sm-2 bg-tertiary rounded-circle"></div>
        <div className="shape-5 shape-sm bg-primary rounded-circle"></div>
        <div className="shape-6 shape-xs bg-secondary rounded-circle"></div>
        <div className="shape-7 shape-xs-2 bg-tertiary rounded-circle"></div>
    </section>
  );
};

export default Countericon;
