import { useState, useEffect } from "react";
import Image from "next/image";
import userImg from "../../../public/images/user1.png";
import Link from "next/link";
import { fetchConnections } from "@/utils/apiActions";
import "@/components/UserChat/userchat.scss";

const ChatSidebar = () => {
    const [myConnections, setMyConnections] = useState([]);
    const [loading, setLoading] = useState(false);
    const pageOffset = 0;
    const perPage = 10;

    const getMyConnections = async () => {
        setLoading(true);
        try {
            const connectionData = await fetchConnections(pageOffset + 1, perPage);
            if (connectionData.status === 1) {
                setMyConnections(connectionData.data);
            } else {
                setMyConnections([]);
            }
        } catch (error) {
            console.error("Error fetching connections:", error);
            setMyConnections([]);
        }
        setLoading(false);
    };

    useEffect(() => {
        getMyConnections();
    }, []);

    return (
        <div className="card shadow-lg border-0">
            <Link href="#" className="text-decoration-none">
            {loading ? (
                <p className="p-3 fw-bold">Loading...</p>
            ) : myConnections.length > 0 && (
                myConnections.map((user) => (
                <div key={user.id || user.name} className="card-body">
                    <div className="d-flex gap-2 align-items-center">
                    <div className="image-wrapper">
                        <Image
                        src={user?.photo?.preview}
                        className="rounded-circle"
                        alt="User"
                        width={40}
                        height={40}
                        />
                    </div>
                    <h5 className="fw-bold text-primary">{user.name}</h5>
                    </div>
                </div>
                ))
            )}
            </Link>
        </div>
      
    );
};

export default ChatSidebar;
