'use client';

import { useState } from 'react';
import Image from 'next/image';
import moment from 'moment';
import { confirmAlert } from 'react-confirm-alert';
import 'react-confirm-alert/src/react-confirm-alert.css';
import ImageNotFound from '../../../public/images/logo.png';
import { useRouter } from 'next/navigation'; 

const SuccessWallCard = (props) => {
    const { challangeItem, token } = props;
    const [showSharePopup, setShowSharePopup] = useState(false);
    const router = useRouter();
    
    const deleteChallangeCallback = async () => {
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "DELETE",
            headers: secureHeader,
            redirect: "follow"
        };

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/challanges/${challangeItem.id}`, requestOptions)
            .then((response) => response.text())
            .then(() => {
                // Redirect or refresh after deletion, if necessary
                router.push('/dashboard/wellness-center/challanges');
            })
            .catch((error) => console.error(error));
    }

    const completeChallangeCallback = async () => {
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);     
        const formdata = new FormData();
        formdata.append("challange_id", challangeItem.id);
        formdata.append("status", 'complete');

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/userchallanges/handle`, requestOptions)
            .then(() => {
                // Redirect to success wall after completing the challenge
                router.push('/dashboard/wellness-center/success-wall');
            })
            .catch((error) => console.error(error));
    }

    const deleteChallange = () => {
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                    <div className='delete-confirm-ui p-3 w-100 mx-auto'>
                        <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">Are you sure?</div>
                        <p className="fs-6 mb-4 pb-4 text-center">Are you sure you want to delete this challange?</p>
                        <div className="d-flex justify-content-end gap-3 border-top brder-gray pt-3">
                            <button className="btn btn-primary btn-sm"
                                onClick={() => { 
                                    deleteChallangeCallback();
                                    onClose();
                                }}
                            >
                                Yes
                            </button>
                            <button className="btn btn-outline-primary btn-sm" onClick={onClose}>No</button>                        
                        </div>
                    </div>
                );
            }
        });
    }

    const completeChallange = () => {
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                    <div className='delete-confirm-ui p-3 w-100 mx-auto'>
                        <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">Are you sure?</div>
                        <p className="fs-6 mb-4 pb-4 text-center">Are you sure you want to complete this challange?</p>
                        <div className="d-flex justify-content-end gap-3 border-top brder-gray pt-3">
                            <button className="btn btn-primary btn-sm"
                                onClick={() => { 
                                    completeChallangeCallback();                             
                                    onClose();
                                }}
                            >
                                Yes
                            </button>
                            <button className="btn btn-outline-primary btn-sm" onClick={onClose}>No</button>                        
                        </div>
                    </div>
                );
            }
        });
    }

    const viewChallange = () => {
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                    <div className='view-challanges-ui p-4 w-100 mx-auto'>
                        <div className='d-flex gap-3'>
                            <div className='position-relative'>
                                {challangeItem?.photo?.preview_url ? (
                                    <Image
                                        src={challangeItem?.photo?.preview_url}
                                        alt={challangeItem.name}
                                        width={100}
                                        height={100}
                                        className='rounded-2'
                                        style={{
                                            objectFit: 'cover',
                                        }}
                                    />
                                ) : 
                                <div className='d-flex flex-column align-items-center w-100 h-100 justify-content-center bg-light'>
                                    <Image
                                        src={ImageNotFound}
                                        width={120}
                                        height={120}
                                        alt=''
                                        style={{
                                        objectFit: 'cover',
                                        }}
                                    />
                                </div>
                                }
                            </div>
                            <div className='w-100'>
                                <div>
                                    <h5 className="fw-bold border-grey mb-2">{challangeItem.name}</h5>
                                    <div>
                                        <i className="ti-calendar me-2"></i>
                                        {moment(challangeItem.start_date).format('MDDY') !== moment(challangeItem.end_date).format('MDDY') ?
                                            <>
                                            {moment(challangeItem.start_date).format('MMM DD,Y')} TO {moment(challangeItem.end_date).format('MMM DD,Y')}
                                            </>
                                            :
                                            <>
                                                {moment(challangeItem.start_date).format('MDDY')}
                                            </>
                                        }
                                    </div>
                                </div>
                                
                                <div className='mb-0'>
                                    <span>
                                        <p><b>Category</b>: {challangeItem.challangecategory_name}</p>
                                    </span>
                                    <span>
                                        <p><b>Type</b>: {challangeItem.challange_type}</p>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div className='border-top mt-2 pt-2'>
                            <h5 className="fw-bold border-grey">Overview</h5>
                            <p>{challangeItem.description}</p>
                        </div>
                        <div className='position-absolute right-0 view-challanges-inner'>
                            <i className="ti-close" onClick={onClose}></i>
                        </div>
                    </div>
                );
            }
        });
    }

    return (
        <>
            <div className='challange-card w-100 h-100 position-relative d-flex flex-column'>
                <div className="card h-100">
                    <div className="card-body">
                        <div className='position-relative'>
                            <div className="image-wrapper position-relative">
                                {challangeItem?.photo?.original_url ? (
                                    <Image
                                        src={challangeItem.photo.original_url}
                                        alt={challangeItem.name}
                                        fill
                                        style={{
                                            objectFit: 'cover',
                                            objectPosition: 'top',
                                        }}
                                    />
                                ) : 
                                <div className='d-flex flex-column align-items-center w-100 h-100 justify-content-center bg-light'>
                                    <Image
                                        src={ImageNotFound}
                                        width={120}
                                        height={120}
                                        alt=''
                                        style={{
                                            objectFit: 'cover',
                                        }}
                                    />
                                </div>
                                }
                                <div className='success-msg-completed w-100' style={{
                                    zIndex: '2'
                                }}>
                                    <span>{challangeItem.status}</span>
                                </div>
                            </div>
                        </div>
                        <h4 className="event-card-title text-primary flex-grow-1 mt-3">
                            <button onClick={viewChallange} className='text-primary fw-bold'>
                                {challangeItem.name}
                            </button>
                        </h4>
                        <p className="mb-3 text-truncate">
                            {challangeItem.description}
                        </p>
                        <div>
                            <span>
                                <p className='text-dark mb-2'><b>Type</b>: {challangeItem.challange_type}</p>
                            </span>
                            <div className='mb-2'>
                                <i className="ti-calendar me-2"></i>
                                {moment(challangeItem.start_date).format('MDDY') !== moment(challangeItem.end_date).format('MDDY') ?
                                    <>
                                    {moment(challangeItem.start_date).format('MMM DD,Y')} TO {moment(challangeItem.end_date).format('MMM DD,Y')}
                                    </>
                                    :
                                    <>
                                        {moment(challangeItem.start_date).format('MDDY')}
                                    </>
                                }
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}

export default SuccessWallCard;
