'use client';

import Image from "next/image";
import { useState } from "react";
import { confirmAlert } from 'react-confirm-alert';
import 'react-confirm-alert/src/react-confirm-alert.css';
import { Tooltip } from 'react-tooltip';
import 'react-tooltip/dist/react-tooltip.css';

const RequestCard=(props)=>{
    const {request, getMyInvitations, token, type} = props;
    const [loading, setLoading] = useState(false);
    

    const declineInvitationCallback=async()=>{        
        const formdata = new FormData();
        formdata.append("action","reject");
        formdata.append("requested_id", request.id);

        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setLoading(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connection/handle`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setLoading(false);
            getMyInvitations();
        })
        .catch((error) => console.error(error));        
    }

    const acceptInvitation=async()=>{        
        const formdata = new FormData();
        formdata.append("action","accept");
        formdata.append("requested_id", request.id);
        
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setLoading(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connection/handle`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setLoading(false);
            getMyInvitations();
        })
        .catch((error) => console.error(error));        
    }

    const cancelRequest=async()=>{        
        const formdata = new FormData();
        formdata.append("requested_id", request.id);
        
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setLoading(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connections/cancel`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setLoading(false);
            getMyInvitations();
        })
        .catch((error) => console.error(error));        
    }

    const declineInvitation = () =>{
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                <div className='delete-confirm-ui p-3 w-100 mx-auto'>
                    <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">Are you sure?</div>
                    <p className="fs-6 mb-4 pb-4 text-center">Are you sure to reject this request?</p>
                    <div className="d-flex justify-content-end gap-3 border-top brder-gray pt-3">
                        <button className="btn btn-primary btn-sm"
                        onClick={() => { 
                            declineInvitationCallback();
                            onClose();
                        }}
                        >
                        Yes
                        </button>
                        <button className="btn btn-outline-primary btn-sm" onClick={onClose}>No</button>                        
                    </div>
                </div>
                );
            }
        });
    }

    return(
        <>
        <div className="my-connection-card d-flex gap-2 gap-md-4 p-2 p-md-3 shadow-sm rounded">
            <div className={`position-relative rounded-circle user-pic-50`}>                                                    
                {request?.photo?.preview ?
                    <Image src={request?.photo?.preview} 
                        alt=""
                        fill                                                                 
                        className="mb-2 rounded-circle"
                        style={{
                            objectFit: 'cover',
                        }}
                        />
                :
                    <i className="ti-user"></i>
                }
            </div>
            <div className="flex-grow-1 d-flex justify-content-between">
                <div className="usermeta">
                    <div className="user-name text-primary mb-1">{request.name}</div>
                    {(request.state || request.country_name) && (
                        <div className="user-location">
                            {request.state && request.country_name 
                                ? `${request.state}, ${request.country_name}` 
                                : request.state || request.country_name}
                        </div>
                    )}

                </div>
                <div className="d-flex gap-2 justify-content-end align-items-center">
                    {type==='invitation' ?
                    <>
                        {!loading ?
                        <>
                            <button type="button" className="btn btn-primary btn-tiny" onClick={acceptInvitation}>Accept</button>
                            <button type="button" className="btn btn-primary btn-tiny" onClick={declineInvitation}>Reject</button>
                        </>
                        :
                        <>
                            <button type="button" className="btn btn-primary btn-tiny">
                                <svg version="1.1" id="loader-1" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                            </button>
                        </>
                        }
                        
                    </>
                    :
                    <>
                        {!loading ?
                            <>
                                <button type="button" className="btn btn-primary btn-tiny" onClick={cancelRequest}>Cancel</button>
                            </>
                            :
                            <>
                                <button type="button" className="btn btn-primary btn-tiny">
                                    <svg version="1.1" id="loader-1" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                                </button>
                            </>
                        }
                    </>
                    }
                </div>
            </div>
        </div>
        </>
    )
}
export default RequestCard;