'use client';

import Image from "next/image";
import { useEffect,useState, useRef } from "react";
import { confirmAlert } from 'react-confirm-alert';
import 'react-confirm-alert/src/react-confirm-alert.css';
import { Tooltip } from 'react-tooltip';
import 'react-tooltip/dist/react-tooltip.css';
import ShareEventPopup from "../Popups/ShareEventPopup";
import Link from "next/link";

const MyConnection=(props)=>{
    const {connection, getMyConnections, token} = props;
    const dropdownRef = useRef(null);
    const [deleteLoading, setDeleteLoading] = useState(false);
    const [showSharePopup, setShowSharePopup] = useState(false);
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    const toggleDropdown = (event) => {
        event.preventDefault();
        setDropdownOpen(!isDropdownOpen);
    };
    const handleClickOutside = (event) => {
        if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
          setDropdownOpen(false);
        }
    };
    useEffect(() => {
        if (isDropdownOpen) {
            document.addEventListener("mousedown", handleClickOutside);
        } else {
            document.removeEventListener("mousedown", handleClickOutside);
        }
    
        return () => {
            document.removeEventListener("mousedown", handleClickOutside);
        };
    }, [isDropdownOpen]);
    const deleteConnectionCallback=async()=>{        
        const formdata = new FormData();
        formdata.append("requested_id", connection.id);
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "POST",
            headers: secureHeader,
            body: formdata,
            redirect: "follow"
        };
        setDeleteLoading(true);
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/connection/remove`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setDeleteLoading(false);
            getMyConnections();
        })
        .catch((error) => console.error(error));        
    }

    const deleteConnection = () =>{
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                <div className='delete-confirm-ui p-3 w-100 mx-auto'>
                    <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">Are you sure?</div>
                    <p className="fs-6 mb-4 pb-4 text-center">Are you sure you want to delete this connection from your list?</p>
                    <div className="d-flex justify-content-end gap-3 border-top brder-gray pt-3">
                        <button className="btn btn-primary btn-sm"
                        onClick={() => { 
                            deleteConnectionCallback();
                            onClose();
                        }}
                        >
                        Yes
                        </button>
                        <button className="btn btn-outline-primary btn-sm" onClick={onClose}>No</button>                        
                    </div>
                </div>
                );
            }
        });
    }

    const shareEvent=()=>{
        setShowSharePopup(true);
    }

    return(
        <>
        <div className="event-card my-connection-card d-flex gap-2 gap-md-4 p-2 p-md-3 shadow-sm rounded">
            <div className={`position-relative rounded-circle user-pic-50`}>                                                    
                {connection?.photo?.preview ? (
                    <Image
                        src={connection?.photo?.preview}
                        alt="User Avatar"
                        fill
                        className="mb-2 rounded-circle"
                        style={{
                        objectFit: 'cover', // cover, contain, none
                        }}
                    />
                    ) : (
                    <i className="ti-user"></i>
                )}

            </div>
            <div className="flex-grow-1 d-flex align-items-baseline justify-content-between">
                <div className="usermeta">
                    <div className="user-name text-primary"><h4>{connection.name}</h4></div>
                    <div className="user-location">
                    {connection.state && connection.country_name 
                        ? `${connection.state}, ${connection.country_name}` 
                        : connection.state || connection.country_name}
                    </div>

                </div>
                {/* <div className="d-flex mt-2 mt-md-0 gap-2 justify-content-end align-items-center">
                    <button type="button" className="user-action-cta" id={`share-event-${connection.id}`} onClick={shareEvent}><i className="ti-calendar"></i></button>
                    <Tooltip anchorSelect={`#share-event-${connection.id}`}>Share Event</Tooltip>
                    <button type="button" className="user-action-cta" id={`send-message-${connection.id}`}><i className="ti-comments"></i></button>
                    <Tooltip anchorSelect={`#send-message-${connection.id}`}><p>Send Message<br/>(Comming Soon)</p></Tooltip>
                    {!deleteLoading ?
                        <button type="button" className="user-action-cta" id={`delete-connection-${connection.id}`} onClick={deleteConnection}><i className="ti-trash"></i></button>
                    :
                        <button type="button" className="user-action-cta" id={`delete-connection-${connection.id}`}>
                            <svg version="1.1" id="loader-1" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                        </button>
                    }
                    
                    <Tooltip anchorSelect={`#delete-connection-${connection.id}`}><p>Delete Connection</p></Tooltip>
                </div> */}
                <div className="event-action challange-actions d-flex gap-2 justify-content-end" ref={dropdownRef}>
                    <button type='button' onClick={toggleDropdown} className="action-cta justify-content-end bottom-0"><i className="ti-more-alt"></i></button>
                    {isDropdownOpen && (
                        <div className="position-absolute right-0 z-2 mt-4 w-48 bg-white border border-gray-200 rounded shadow-lg">
                            <ul className='list-actions p-3 mb-0'>
                                <li className="pb-3 hover:bg-gray-100 cursor-pointer d-flex align-items-center gap-2"><button type="button" className="" id={`share-event-${connection.id}`} onClick={shareEvent}><i className="ti-calendar me-2"></i> <span>Share Event</span></button></li>

                                <li className="pb-3 hover:bg-gray-100 cursor-pointer d-flex align-items-center gap-2"><Link href={`/chat?${connection.user_id}`} className="text-decoration-none text-black" id={`send-message-${connection.id}`}><i className="ti-comments me-2"></i> <span>Send Message</span></Link></li>
                                <li className="hover:bg-gray-100 cursor-pointer d-flex align-items-center gap-2">
                                {!deleteLoading ?
                                    <button type="button" className="" id={`delete-connection-${connection.id}`} onClick={deleteConnection}><i className="ti-trash me-2"></i><span>Delete Connection</span></button>
                                :
                                    <button type="button" className="" id={`delete-connection-${connection.id}`}>
                                        <svg version="1.1" id="loader-1" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 40 40" enableBackground="new 0 0 40 40"><path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>
                                         
                                    </button>
                                }
                                
                                </li>
                            </ul>
                            
                        </div>
                    )}
                </div>
            </div>
        </div>
        {showSharePopup &&
            <ShareEventPopup setShowPopup={setShowSharePopup} connection={connection} token={token} />
        }
        </>
    )
}
export default MyConnection;