import Link from "next/link";
const BoxCardStyleTwo=(props)=>{
    const {title, text, iconClass, hasLink} = props;
    return(
        <>
        <div className="boxblock-style-2 block p-4 p-xl-5 text-center h-100 w-100">            
            {hasLink!=null ?
                <Link href={hasLink} className="service-icon d-block text-center mx-auto rounded-circle">
                    <i className={`${iconClass}`}></i>
                </Link>
            :
                <div className="service-icon text-center mx-auto rounded-circle"><i className={`${iconClass}`}></i></div>
            }
            
            {title!==null &&
                <>
                {hasLink!=null ?
                    <h3 className="font-weight-600 mt-20 mb-20"><Link href={hasLink} className="text-black">{title}</Link></h3>
                    :
                    <h3 className="font-weight-600 mt-20 mb-20">{title}</h3>
                }
                </>
            }
            {text!==null &&
                <p>{text}</p>
            }
        </div>        
        </>
    )
}

BoxCardStyleTwo.defaultProps = {
    title: null,
    text: null,
    iconClass: null,
    hasLink:null
};

export default BoxCardStyleTwo;