import Link from "next/link";
const BoxCardStyleOne=(props)=>{
    const {title, text, iconClass, hasLink} = props;
    return(
        <>
            {hasLink ?
                <Link href="#" className="bg-white shadow rounded p-30 h-100" data-aos="fade-up" data-aos-delay="50">
                    <div className="d-flex justify-content-between mb-2 mb-lg-3">
                        <h3 className="mb-2 mb-lg-4 font-weight-600">{title}</h3>
                        {iconClass!=="" && iconClass!==null &&
                            <div className="has-text-color h2">
                                <i className={iconClass}></i>
                            </div>
                        }
                    </div> 
                    {text!=="" && text!==null &&                               
                        <div className="accordion-panel">
                            <p>{text}</p>
                        </div>
                    }
                </Link>
            :
                <div className="bg-white shadow rounded p-30 h-100" data-aos="fade-up" data-aos-delay="50">
                    <div className="d-flex justify-content-between mb-2 mb-lg-3">
                        <h3 className="mb-2 mb-lg-4 font-weight-600">{title}</h3>
                        {iconClass!=="" && iconClass!==null &&
                            <div className="has-text-color h2">
                                <i className={iconClass}></i>
                            </div>
                        }
                    </div> 
                    {text!=="" && text!==null &&                               
                        <div className="accordion-panel">
                            <p>{text}</p>
                        </div>
                    }
                </div>
            }
        </>
    )
}

BoxCardStyleOne.defaultProps = {
    title: null,
    text: null,
    iconClass: null,
    hasLink:false
};

export default BoxCardStyleOne;