'use client';
import Image from "next/image";
import { useState, useEffect } from "react";
import moment from "moment";
import { confirmAlert } from "react-confirm-alert";
import "react-confirm-alert/src/react-confirm-alert.css";
import Comments from "./Comments";
import { useDropzone } from "react-dropzone";


moment.updateLocale('en', {
    relativeTime: {
      future: 'in %s',
      past: '%s ago',
      s: 'a few seconds',
      ss: '%d seconds',
      m: 'a minute',
      mm: '%d minutes',
      h: 'an hour',
      hh: '%d hours',
      d: '%d day',
      dd: '%d days',
      M: '%d month',
      MM: '%d months',
      y: '%d year',
      yy: '%d years',
    },
});

const PostItem = (props) => {
    const { post, currentUser, token, dispatch, deleteAnnouncementAction, likeAnnouncementAction, updateCommentCountAction } = props;
    const [isMounted, setIsMounted] = useState(false);
    const [isLikedByMe, setIsLikedByMe] = useState(false);
    const [deleteLoading, setDeleteLoading] = useState(false);
    const [showLinksPopup, setShowLikesPopup] = useState(false);
    const [showCommentBox, setShowCommentBox] = useState(false);
    const [isEditing, setIsEditing] = useState(false);
    const [editedText, setEditedText] = useState(post.post);
    const [editLoading, setEditLoading] = useState(false);

    const deletePost = () => {
        confirmAlert({
            customUI: ({ onClose }) => (
                <div className='delete-confirm-ui p-3 w-100 mx-auto'>
                    <div className="fs-5 fw-bold border-bottom pb-2 mb-2 text-center">Are you sure?</div>
                    <p className="fs-6 mb-4 text-center">Are you sure you want to delete this post?</p>
                    <div className="d-flex justify-content-end gap-3 border-top pt-3">
                        <button className="btn btn-primary btn-sm" onClick={() => { deletePostCallback(); onClose(); }}>Yes</button>
                        <button className="btn btn-outline-primary btn-sm" onClick={onClose}>No</button>
                    </div>
                </div>
            )
        });
    }

    const deletePostCallback = async () => {
        setDeleteLoading(true);
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);

        const requestOptions = {
            method: "DELETE",
            headers: secureHeader
        };

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/announcments/${post.id}`, requestOptions)
            .then((response) => response.text())
            .then(() => {
                setDeleteLoading(false);
                dispatch(deleteAnnouncementAction({ id: post.id }));
            })
            .catch((error) => console.error(error));
    }

    const LikePopup=(props)=>{
        const {postdata, setShowPopup} = props;
        return(
            <div className="popup-screen">
                <div className="popup-screen-inner p-0">
                    <div className="view-challanges-ui p-4">
                        <div className="d-flex flex-column gap-3">
                            {postdata.likes.length>0 && postdata.likes.map((item) => (
                                <div key={item.id} className="d-flex align-items-center gap-2 border-bottom pb-3">
                                    <div className="position-relative rounded-circle user-pic-40">
                                        {item?.photo !== null ?
                                            <Image
                                                src={item?.photo.original_url}
                                                height={40}
                                                width={40}
                                                alt="Brand Logo"
                                                className="rounded-pill mr-3"
                                                style={{ objectFit: "cover" }}
                                            />
                                            :
                                            <i className="ti-user"></i>
                                        }
                                    </div>
                                    <div>
                                        <h6 className="mb-0 fw-bold">{item.name} {item.lastname}</h6>
                                    </div>
                                </div>
                            ))}
                        </div>
                        <div className="position-absolute right-0 view-challanges-inner">
                            <i className="ti-close" onClick={()=>{setShowPopup(false)}}></i>
                        </div>
                    </div>
                </div>
            </div>
        )
    }

    const toggleLikes = async () => {
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);
        const action = isLikedByMe ? "unlike" : "like";
        const formdata = new FormData();
        formdata.append('post_id', post.id);
        formdata.append('action', action);

        const requestOptions = {
            method: 'POST',
            headers: secureHeader,
            body: formdata,
        };

        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/likes`, requestOptions)
            .then((response) => response.text())
            .then((result) => {
                let rdata = JSON.parse(result);
                if (rdata.status === 1) {
                    setIsLikedByMe(!isLikedByMe);
                    dispatch(likeAnnouncementAction(rdata.data));
                }
            })
            .catch((error) => console.error(error));
    }

    const [updatedPost, setUpdatedPost] = useState(post);
    const handleEditSave = async () => {
        setEditLoading(true);
        const formData = new FormData();
        formData.append('post', editedText);
    
        if (files.length > 0) {
            formData.append('photo', files[0].file);
        }
    
        const secureHeader = new Headers();
        secureHeader.append("Authorization", `Bearer ${token}`);
    
        const requestOptions = {
            method: 'POST',
            headers: secureHeader,
            body: formData,
        };
    
        try {
            const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/announcments/${post.id}`, requestOptions);
            const data = await response.json();
    
            if (response.ok) {
                setUpdatedPost(prev => ({
                    ...prev,
                    post: editedText,
                    photo: files.length > 0 ? { original_url: URL.createObjectURL(files[0].file) } : prev.photo,
                }));
                dispatch(updateCommentCountAction({ id: post.id }));
                setIsEditing(false);
                setFiles([]);
            } else {
                console.error("Error saving changes", data);
            }
        } catch (error) {
            console.error("Error:", error);
        } finally {
            setEditLoading(false);
        }
    };
    

    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
    }, [isMounted]);

    useEffect(() => {
        let inLikedList = [];
        if (post.likes?.length > 0) {
            inLikedList = post.likes.filter((item) => item.id === currentUser.id);
        }
        if (inLikedList.length > 0) {
            setIsLikedByMe(true);
        }
    }, [post]);


    const [files, setFiles] = useState([]);
    const [fileError, setFileError] = useState(null);
    const { isDragActive, getRootProps, getInputProps, open } = useDropzone({
        noClick: true,
        noKeyboard: true,
        accept: {
            'image/*': ['.png', '.jpeg', '.jpg', '.gif', '.webp'],
        },
        maxFiles: 1,
        onDrop: acceptedFiles => {
            let tmpFiles = files;
            acceptedFiles.map((file) => {
                let tmpObj = {};
                tmpObj.file = file;
                tmpObj.preview = URL.createObjectURL(file);
                tmpObj.size = file.size;
                tmpObj.type = file.type;
                tmpObj.name = file.name;
                tmpFiles.push(tmpObj);
            });
            setFiles(tmpFiles);
        },
        onDropRejected: (rejections) => {
            setFileError('File rejected: ' + rejections);
        },
    });


    return (
        <>
        <div className="card mb-4 post-card-main position-relative">
            <div className="card-header d-flex justify-content-between align-items-center bg-white border-bottom-0">
                <div className="d-flex align-items-center w-100">
                    <div className="position-relative rounded-circle user-pic-40">
                        {post?.user?.photo?.original_url ? (
                            <Image src={post.user.photo.original_url} height={40} width={40} alt="User" className="rounded-pill" style={{ objectFit: "cover" }} />
                        ) : (
                            <i className="ti-user"></i>
                        )}
                    </div>
                    <div className="ms-2">
                        <h6 className="mb-0 fw-bold lh-sm">{post?.user?.name}</h6>
                        <p className="text-muted" style={{ fontSize: '0.8rem' }}>{moment(new Date(post.created_at)).fromNow()}</p>
                    </div>
                    {post.is_owner && (
                        <div className="ms-auto d-flex align-items-end">
                            <button className="btn btn-sm text-primary" onClick={() => setIsEditing(!isEditing)}>
                                <i className="ti-pencil me-2"></i>
                            </button>
                            <button className="btn btn-sm" onClick={deletePost}>
                                <i className="ti-trash"></i>
                            </button>
                        </div>
                    )}
                </div>
            </div>
            

            <div className="card-body py-2 my-2 rounded">
            {isEditing ? (
                <>
                    <h5 className="fw-normal pb-3 text-primary">Edit Post</h5>
                    <input
                        className="form-control mb-2"
                        value={editedText}
                        onChange={(e) => setEditedText(e.target.value)}
                    />
                    {files.length <= 0 ? 
                        <div {...getRootProps({ className: `file-dropper` })}>
                            <input {...getInputProps()} />
                            <div className={`file-dropper-inner position-relative`} onClick={open}>
                                {updatedPost?.photo?.original_url ? (
                                    <Image
                                        src={updatedPost.photo.original_url}
                                        alt="Current Image"
                                        width={200}
                                        height={200}
                                        className="mb-2 cursor-pointer rounded"
                                        style={{ objectFit: 'cover' }}
                                    />
                                ) : (
                                    <svg className="mb-2" width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g opacity="0.8">
                                            <path d="M57 15V57H15V15H57ZM57 9H15C11.7 9 9 11.7 9 15V57C9 60.3 11.7 63 15 63H57C60.3 63 63 60.3 63 57V15C63 11.7 60.3 9 57 9ZM42.42 35.58L33.42 47.19L27 39.42L18 51H54L42.42 35.58Z" fill="#FF3158" />
                                        </g>
                                    </svg>
                                )}
                                <p>Drag Images Here Or <span type="button" className="text-primary">Browse</span></p>
                                {fileError && <p className='text-red-500 text-sm'>{fileError}</p>}
                            </div>
                        </div>
                        :
                        <div className="file-dropper">
                            <div className="file-dropper-inner has-preview position-relative">
                                <Image src={files[0].preview} alt="Uploaded Preview" width={200} height={200} className="mb-2 rounded w-100"/>
                                <button type="button" className="btn btn-primary px-3 py-2 ms-2 shadow-sm" onClick={() => setFiles([])}>Cancel</button>
                            </div>
                        </div>
                    }

                    <div className="text-end mt-3">
                        <button className="btn btn-primary px-3 py-2 ms-2 shadow-sm" onClick={handleEditSave}>Save</button>
                        <button className="btn btn-secondary px-3 py-2 ms-2 shadow-sm" onClick={() => setIsEditing(false)}>Cancel</button>
                    </div>
                </>
            ) : (
                <>
                    <p className='mb-1'>{updatedPost.post}</p>
                    <div className="position-relative">
                        {updatedPost?.photo?.original_url && (
                            <Image
                                src={updatedPost.photo.original_url}
                                alt="Updated Image"
                                width={800}
                                height={300}
                                className="img-fluid rounded"
                            />
                        )}
                    </div>
                </>
            )}
            {editLoading && (
                <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                    <div className="lds-ripple"><div></div><div></div></div>
                </div>
            )}
            </div>
            <div className="card-footer bg-white">
                    <div className="d-flex mb-2 count-list">
                        {post.likes_count > 0 &&
                            <p
                                onClick={() => setShowLikesPopup(true)}
                                className="d-flex align-items-center gap-1 cursor-pointer text-gray-600 hover:text-gray-800"
                            >
                                <i className="ti-thumb-up me-1"></i>
                                {post.likes_count}
                            </p>
                        }
                        <p className="ms-auto mt-0" onClick={() => setShowCommentBox(!showCommentBox)}>{post.comments_count} Comments</p>
                    </div>
                    <div className="d-flex justify-content-between gap-1 mb-2 userclick-button">
                        <button
                            type="button"
                            className={`d-flex align-items-center gap-2 px-2 px-md-3 py-2 rounded-lg transition duration-300 ${
                                isLikedByMe ? 'text-white active-like bg-red-500' : 'active-unlike'
                            }`}
                            onClick={() => toggleLikes()}
                        >
                            <i className={`ti-thumb-up ${isLikedByMe ? 'text-white' : 'text-gray-400'}`}></i>
                            Like
                        </button>
                        <button
                            type="button"
                            className="btn btn-primary d-flex align-items-center gap-2"
                            onClick={() => setShowCommentBox(!showCommentBox)}
                        >
                            <i className="ti-comment-alt"></i> Comment
                        </button>
                    </div>
                </div>
                {showCommentBox &&
                    <Comments currentUser={currentUser} post={post} setShowCommentBox={setShowCommentBox} token={token} dispatch={dispatch} updateCommentCountAction={updateCommentCountAction} />
                }
                {deleteLoading &&
                    <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                }
        </div>
        {showLinksPopup &&
            <LikePopup setShowPopup={setShowLikesPopup} postdata={post} />
        }
        </>
    );
}

export default PostItem;
