'use client';
import { useState, useEffect, useRef } from "react";
import Image from "next/image";
import { fetchGetAllComments } from "@/utils/apiActions";
import CommentRow from "./CommentRow";

const Comments=(props)=>{
    const {currentUser, post, token, dispatch, updateCommentCountAction} = props;
    const [content, setContent] = useState('');
    const [isMounted, setIsMounted] = useState(false);
    const [isFocused, setIsFocused] = useState(false);
    const [loading, setLoading] = useState(false);
    const [submitLoading, setSubmitLoading] = useState(false);
    const [commentsList, setCommentList] = useState([]);
    
    const divRef = useRef(null);
    
    const handleFocus = () => {
        setIsFocused(true);
        if (content === '') {
          setContent('');
        }
    };
    
    const handleBlur = () => {
        setIsFocused(false);
    };
    
    const handleChange = (e) => {
        setContent(e.target.innerText);
    };

    const handleAddComment=async()=>{
        setSubmitLoading(true);
        var formdata = new FormData();
        formdata.append('comment', content);
        formdata.append('post_id', post.id);

        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);

        const requestOptions = {
            method: 'POST',
            redirect: 'follow',
            headers: secureHeader,
            body: formdata
        };
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/comments`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setSubmitLoading(false);
            let rdata = JSON.parse(result);
            if(rdata.status===1){
                //dispatch(likeAnnouncementAction(rdata.data));
                setContent('');
                if (divRef.current) {
                    divRef.current.innerText = '';
                }
                getPostComments();
            }
            else{
                console.log(rdata.message);
            }
        })
        .catch((error) => console.error(error));
    }

    const getPostComments=async()=>{
        setLoading(true);
        setCommentList([]);
        const [commentsData] = await Promise.all([
            fetchGetAllComments(post.id),
        ]);

        if (commentsData.status === 1) {
            setCommentList(commentsData.data);
            dispatch(updateCommentCountAction({id:post.id, comments_count:commentsData.data.length}));
        }
        else{
            console.log(commentsData.message);
        }
        setLoading(false);
    }

    useEffect(() => {
        const div = divRef.current;
        if (div) {
          div.style.height = 'auto';
          div.style.height = `${div.scrollHeight}px`;
        }
    }, [content]);

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getPostComments();
    },[isMounted]);
    
    return(
        <div className="comments-section">
            <div className="comment-box mt-0 px-2 px-md-3 border-top">
                <div className="d-flex pe-2 pe-md-2 pe-lg-0 justify-content-between align-items-start gap-2 mb-3 mt-3 position-relative">
                    <div className="position-relative rounded-circle user-pic-40">
                        {currentUser?.photo?.preview ?
                            <Image
                                src={currentUser.photo.preview}
                                height={40}
                                width={40}
                                alt="Brand Logo"
                                className="rounded-pill mr-3 col-auto"
                                style={{ objectFit: "cover" }}
                            />
                            :
                            <>
                                <i className="ti-user"></i>
                            </>
                        }
                    </div>
                    <div className='col-10 col-md-11 comment-box-input d-flex position-relative' style={{
                        minHeight: '50px',
                        border: '1px solid #ccc',
                        padding: '9px',
                        backgroundColor: content === '' && !isFocused ? '#fff' : 'white',
                    }}>
                        <div
                            ref={divRef}
                            contentEditable
                            suppressContentEditableWarning
                            className="col-11"
                            onFocus={handleFocus}
                            onBlur={handleBlur}
                            onInput={handleChange}
                            style={{
                                padding: '0px',
                                position: 'relative',
                                backgroundColor: content === '' && !isFocused ? '#fff' : 'white',
                            }}
                        >
                            {content === '' && !isFocused && (
                                <span
                                    style={{
                                        color: '#aaa',
                                        position: 'absolute',
                                        top: '2px',
                                        left: '12px',
                                        pointerEvents: 'none',
                                    }}
                                >
                                Add comment...
                                </span>
                            )}
                        </div>
                        <div className="position-absolute end-0 me-3 me-lg-4 mt-1 d-flex gap-2 send-button">
                            <button
                                type="button"
                                onClick={() => handleAddComment()}
                            >
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    height="24px"
                                    viewBox="0 -960 960 960"
                                    width="24px"
                                    fill={!content.trim() ? "#ccc" : "#FF3158"}
                                >
                                    <path d="M120-160v-640l760 320-760 320Zm80-120 474-200-474-200v140l240 60-240 60v140Zm0 0v-400 400Z" />
                                </svg>
                            </button>
                        </div>
                    </div>                    
                    {submitLoading &&
                        <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                            <div className="lds-ripple"><div></div><div></div></div>
                        </div>
                    }
                </div>
                <div className="position-relative">
                    {loading &&
                        <div style={{ width: '100%', height: '200px', position: 'relative' }}>
                            <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                                <div className="lds-ripple"><div></div><div></div></div>
                            </div>
                        </div>
                    }
                    {commentsList.length > 0 &&
                        <>
                        {commentsList.map((comment) => {
                            return(
                                <CommentRow 
                                    key={`${comment.id}-${comment.created_at}`} 
                                    post={post} 
                                    comment={comment} 
                                    token={token} 
                                    getPostComments={getPostComments} 
                                    dispatch={dispatch} 
                                />
                            )
                        })}
                        </>
                    }
                </div>
            </div>
        </div>
    )
}

export default Comments;