'use client';

import Image from "next/image";
import { useState } from "react";
import { confirmAlert } from "react-confirm-alert";
import "react-confirm-alert/src/react-confirm-alert.css";
import moment from "moment";
moment.updateLocale('en', {
    relativeTime: {
      future: 'in %s',
      past: '%s ago',
      s: 'a few seconds',
      ss: '%d seconds',
      m: 'a minute',
      mm: '%d minutes',
      h: 'an hour',
      hh: '%d hours',
      d: '%d day',
      dd: '%d days',
      M: '%d month',
      MM: '%d months',
      y: '%d year',
      yy: '%d years',
    },
});

const CommentRow=(props)=>{
    const {comment,token, getPostComments} = props;
    const [loading, setLoading] = useState(false);

    const deleteComment = () => {
        confirmAlert({
            customUI: ({ onClose }) => {
                return (
                    <div className="delete-confirm-ui p-3 w-100 mx-auto">
                        <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">
                            Are you sure?
                        </div>
                        <p className="fs-6 mb-4 pb-4 text-center">
                            Are you sure you want to delete this comment?
                        </p>
                        <div className="d-flex justify-content-end gap-3 border-top border-gray pt-3">
                            <button
                                className="btn btn-primary btn-sm"
                                onClick={() => {
                                    handleDeleteComment();
                                    onClose();
                                }}
                            >
                                Yes
                            </button>
                            <button className="btn btn-outline-primary btn-sm" onClick={onClose}>
                                No
                            </button>
                        </div>
                    </div>
                );
            },
        });
    };

    const handleDeleteComment=async()=>{
        setLoading(true);
        var secureHeader = new Headers();
        secureHeader.append('Authorization', 'Bearer ' + token);
        
        const requestOptions = {
            method: 'DELETE',
            redirect: 'follow',
            headers: secureHeader,
        };
        
        await fetch(`${process.env.NEXT_PUBLIC_API_URL}api/v1/comments/${comment.comment_id}`, requestOptions)
        .then((response) => response.text())
        .then((result) => {
            setLoading(false);
            let rdata = JSON.parse(result);
            if(rdata.status===1){
                getPostComments();
            }
            else{
                console.log(rdata.message);
            }
        })
        .catch((error) => console.error(error));
    }

    return(
        <div key={`${comment.comment_id}-${comment.created_at}`} className="comment">
            <div className="d-flex align-items-start gap-2 mb-3 mt-3">
                <div className="w-100 d-flex align-items-top gap-2">
                    <div className="position-relative rounded-circle user-pic-40">
                    {comment.user?.photo?.thumbnail ?
                        <Image
                            src={comment.user.photo.thumbnail}
                            height={40}
                            width={40}
                            alt="User Photo"
                            className="rounded-pill mr-3"
                            style={{ objectFit: "cover" }}
                        />
                        :
                        <>
                            <i className="ti-user"></i>
                        </>
                    }
                    </div>
                    <div className="comment-box-inner d-flex">
                        <div>
                            <span className="fw-bold text-capitalize">
                                <span className='me-1'>{comment.user?.firstname || comment.firstname}</span>
                                <span>{comment.user?.lastname || comment.lastname}</span>
                            </span>
                            <p>{comment.comment}</p>
                        </div>
                        <div className="ms-auto d-flex">
                            <span className="me-2">
                                {moment(new Date(comment.created_at)).fromNow()}
                            </span>
                            {comment.is_owner && (
                                <button
                                    className="btn btn-sm p-0"
                                    onClick={() => deleteComment()}
                                >
                                    <i className="ti-trash"></i>
                                </button>
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default CommentRow;