'use client'
import { useState, useEffect } from 'react';
import { useDispatch, useSelector } from "react-redux";
import { fetchListAllPost } from '@/utils/apiActions';
import { getAuthToken } from '@/utils/auth';
import PostItem from './PostItem';
import CreatePost from '@/components/CreatePost/CreatePost';
import { fetchAnnouncementsAction, deleteAnnouncementAction, likeAnnouncementAction, updateCommentCountAction } from "@/store/slices/announcementsSlice";
//import AllPost from '@/components/AllPost/AllPost';


const Announcement = () => {
    const [loading, setLoading] = useState(false);
    const token = getAuthToken();
    const announcementListObj = useSelector(state => state.announcements);
    const allPost = announcementListObj.announcementsData;
    const [isCreatePostVisible, setCreatePostVisible] = useState(false);
    const [isMounted, setIsMounted] = useState(false);
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    const dispatch=useDispatch();
    

    const toggleCreatePost = () => {
        setCreatePostVisible(!isCreatePostVisible);
    };

    const getAllAnnouncements = async() =>{
        setLoading(true);
        const [announcementsData] = await Promise.all([
            fetchListAllPost(),
        ]);

        if (announcementsData.status === 1) {
            dispatch(fetchAnnouncementsAction(announcementsData.data));            
        }
        else{
            console.log(announcementsData.message);
        }
        setLoading(false);
    }

    useEffect(()=>{
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        getAllAnnouncements();
    },[isMounted]);

    return (
        
        <div className="container mt-4">
            <div className="row justify-content-center">
                <div className="d-flex flex-wrap flex-md-nowrap justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
                    <div className="col-auto">
                        <h2 className="section-title mb-0">Announcement</h2>
                    </div>
                    <div className="d-flex mt-2 mt-md-0 justify-content-end align-items-start align-items-md-center">
                        <div className="col-auto data-action-bar">
                            <button
                                type="button"
                                className="data-action-cta data-action-cta-text shadow-sm"
                                onClick={toggleCreatePost}
                            >
                                <i className="ti-plus me-1"></i> Create Post
                            </button>
                        </div>
                    </div>
                </div>
                {isCreatePostVisible && <CreatePost setIsVisible={setCreatePostVisible} isVisible={isCreatePostVisible} />}
                {!loading ?
                <>
                    {allPost.length>0 ?
                        <>
                            {allPost.map((post)=>{
                                return(
                                    <PostItem 
                                        key={post.id}     
                                        post={post} 
                                        refreshAnnouncements={getAllAnnouncements}
                                        currentUser={currentUser} 
                                        token={token} 
                                        dispatch={dispatch} 
                                        deleteAnnouncementAction={deleteAnnouncementAction}
                                        likeAnnouncementAction={likeAnnouncementAction}
                                        updateCommentCountAction={updateCommentCountAction}
                                    />
                                )
                            })}
                        </>
                        :
                        <>
                            <div className="col-md-12">
                                <h5 className="text-center fw-normal">No posts available at the moment, create new post now.</h5>
                            </div>
                        </>
                    }
                </>
                :
                <>
                    <div style={{ width: '100%', height: '300px', position: 'relative' }}>
                        <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                            <div className="lds-ripple"><div></div><div></div></div>
                        </div>
                    </div>
                </>
                }
                
            </div>
        </div>

    );
};

export default Announcement;
