'use client';
import React, { useState } from 'react';

const AccordionSection = () => {
  // Set the first accordion as open by default
  const [openAccordion, setOpenAccordion] = useState('FAQoneCollapseOne');

  const toggleAccordion = (id) => {
    setOpenAccordion(openAccordion === id ? null : id);
  };

  return (
    <section id="needhelp" className="section-padding pb-50">
      <div className="container">
        <div className="row justify-content-center">
          <div className="col-lg-10">
            <h2 className="section-title">Got A <strong>Question?</strong></h2>
          </div>

          <div className="col-lg-10">
            {/* Accordion 1 */}
            <div className="accordion accordionFAQ mb-40" id="accordionFAQone">
              <h3 className="text-black-200 font-weight-bold mb-10">How do I use the DTT web portal?</h3>

              <div className="card border-0 border-bottom">
                <div className="card-header border-0 bg-transparent py-0">
                  <h4 
                    className={`py-4 ${openAccordion === 'FAQoneCollapseOne' ? 'active-title' : ''}`} 
                    onClick={() => toggleAccordion('FAQoneCollapseOne')}
                  >
                    <i 
                      className={`accordion-arrow ti-angle-down ${openAccordion === 'FAQoneCollapseOne' ? 'rotate' : ''}`} 
                    ></i>
                    Getting Started!
                  </h4>
                </div>

                <div id="FAQoneCollapseOne" className={`collapse ${openAccordion === 'FAQoneCollapseOne' ? 'show' : ''}`}>
                  <div className="card-body pt-2">
                    <div className="mb-15">
                      <p className="font-weight-600 mb-1">Step 1</p>
                      <p>Request an invitation to join the network by completing the registration form and providing the requested information.</p>
                    </div>
                    <div className="mb-15">
                      <p className="font-weight-600 mb-1">Step 2</p>
                      <p>Login  using your credentials</p>
                    </div>
                    <div className="mb-15">
                      <p className="font-weight-600 mb-1">Step 3</p>
                      <p>Choose appropriate plan for subscription and make a payment.
                      </p>
                    </div>
                    <div className="mb-15">
                      <p className="font-weight-600 mb-1">Step 4</p>
                      <p>Start using dashboard Features</p>
                    </div>
                  </div>
                </div>
              </div>

              {/* Additional Accordion Items */}
              {/* Uncomment if needed */}
              {/* <div className="card border-0">
                <div className="card-header border-0 bg-transparent py-0">
                  <h4 
                    className={`py-4 ${openAccordion === 'FAQoneCollapseTwo' ? 'active-title' : ''}`} 
                    onClick={() => toggleAccordion('FAQoneCollapseTwo')}
                  >
                    <i 
                      className={`accordion-arrow ti-angle-down ${openAccordion === 'FAQoneCollapseTwo' ? 'rotate' : ''}`} 
                    ></i>
                    How can I use the Keepsake Chest with cloud documents?
                  </h4>
                </div>

                <div id="FAQoneCollapseTwo" className={`collapse ${openAccordion === 'FAQoneCollapseTwo' ? 'show' : ''}`}>
                  <div className="card-body pt-2">
                    <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid...</p>
                  </div>
                </div>
              </div> */}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default AccordionSection;
