"use client"
import { Quicksand } from "next/font/google";
import "../../styles/bootstrap.scss";
import "../../styles/scss/style.scss";
import "../../themify-icons/themify-icons.css";
import Header from "@/components/Header/header";
import Footer from "@/components/Footer/footer";
import { useEffect } from 'react';
import { usePathname } from 'next/navigation';
const quicksand = Quicksand({ 
  weight: ['500', '600', '700'],
  subsets: ["latin"], 
  display: 'swap', 
  variable:'--font-quicksand' });
export default function RootLayout({ children }) {
  const pathname = usePathname();

  useEffect(() => {
    const body = document.body;
    const bodyClass = pathname.replace(/\//g, "-").replace(/^-/, "") || "home";
    body.classList.add("dashboard", bodyClass);
    return () => {
      body.classList.remove(bodyClass);
    };
  }, [pathname]);
  return (
    <html lang="en">
      <meta name="robots" content="noindex, nofollow" />
      <title>During Those Time</title>
      {/* <script type="text/javascript" src="https://www.bugherd.com/sidebarv2.js?apikey=zf3ol8563feckta4khpjvq" async="true"></script> */} 
      <body className={`home-page ${quicksand.variable}`}>
        <Header />
        {children}
        <Footer />
      </body>
    </html>
  );
}
