'use client'
import { useState, useEffect } from "react";
import { fetchChallangesAll, fetchUserDetail, fetchSelectedBadges } from "@/utils/apiActions";
import SuccessCard from "@/components/Cards/SuccessCard";
import { getAuthToken } from "@/utils/auth";
import ReactPaginate from "react-paginate";
import Image from "next/image";
import { Tooltip } from 'react-tooltip';

const MyChallangesPage = () => {
    const [loading, setLoading] = useState(false);
    const [challangesList, setChallangesList] = useState([]);
    const [isMounted, setIsMounted] = useState(false);
    const [pageOffset, setPageOffset] = useState(0);
    const [currentUser, setCurrentUser] = useState({});
    const [userBadges, setUserBadges] = useState([]);
    const [selectedCategory, setSelectedCategory] = useState('all');
    const perPage = 10;
    const [pageCount, setPageCount] = useState(0);
    const token = getAuthToken();

    const getEvents = async () => {
        setLoading(true);
        const [challangeData, response, userbadges] = await Promise.all([
            fetchChallangesAll(selectedCategory, pageOffset + 1, perPage),
            fetchUserDetail(),
            fetchSelectedBadges(),
        ]);
        setCurrentUser(response.badges); 
        setUserBadges(userbadges.data.badges);  

        if (challangeData.status === 1) {
            setChallangesList(challangeData.data);
            setPageCount(challangeData.pagination.last_page);
        }
        setLoading(false);
    };

    const handlePageChange = (event) => {
        setPageOffset(event.selected);
    };
    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        getEvents();
    }, [isMounted, pageOffset, perPage]);
    return (
        <div className="main">
            <section>
                <div className="container">
                    <div className="d-flex justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
                        <div className="col-auto d-block d-md-flex justify-content-between w-100 align-items-center">
                            <h2 className="section-title mb-3 mb-md-0">Success Wall</h2>
                            <div className="d-flex align-items-center gap-2">
                                {userBadges.length>0 &&
                                    <ul className="badges d-flex align-items-center gap-2 gap-md-2 justify-content-center">
                                        <p className="fw-bold">My Badges:</p>
                                        {userBadges.map((badge)=>{
                                            return(
                                                <li key={badge.id} className={`${userBadges.includes(badge.id) ? 'bg-danger-subtle' : 'bg-dark-subtle'} rounded p-1 p-md-2`}>
                                                    <Image 
                                                        alt={badge.name}
                                                        src={badge.icon.original_url}
                                                        width={25}
                                                        height={25}
                                                        id={`badge-${badge.id}`}
                                                    />
                                                    <Tooltip anchorSelect={`#badge-${badge.id}`}><p>{badge.name}</p></Tooltip>
                                                </li>
                                            )
                                        })}
                                    </ul>
                                    }
                            </div>
                        </div>
                    </div>
                    <div className="position-relative">
                        <div className="row justify-content-start">
                        {challangesList.length > 0 && (
                            challangesList.some((item) => item.status === 'complete') ? (
                                challangesList.map((item) =>
                                    item.status === 'complete' && (
                                        <div className="col-md-4 w-screen g-4 g-md-2" key={item.id}>
                                            <SuccessCard
                                                challangeItem={item}
                                                token={token}
                                                isShared={false}
                                            />
                                        </div>
                                    )
                                )
                            ) : (
                                <div className="text-start w-100">
                                    <h5 className="text-muted">Challenges not found.</h5>
                                </div>
                            ))}

                        </div>
                    </div>
                    {loading &&
                        <>
                            <div className="css-loader">
                                <div className="lds-ripple"><div></div><div></div></div>
                            </div>
                        </>
                    }
                </div>
            </section>
        </div>
    );
};
export default MyChallangesPage;
