'use client'
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import Link from "next/link";
import { fetchChallangesAll } from "@/utils/apiActions";
import ProgressCard from "@/components/Cards/ProgressCard";
import { fetchEventsAction, deleteEventAction } from "@/store/slices/eventsSlice";
import { getAuthToken } from "@/utils/auth";
import { usePathname } from "next/navigation";
import ReactPaginate from "react-paginate";

const MyChallangesPage = () => {
    const [loading, setLoading] = useState(false);
    const challangesListObj = useSelector(state=>state.events);
    const challangesList = challangesListObj.eventsData;
    const [isMounted, setIsMounted] = useState(false);
    const [pageOffset, setPageOffset] = useState(0);
    const [selectedCategory, setSelectedCategory] = useState('all');
    const perPage = 10;
    const dispatch = useDispatch();
    const [pageCount, setPageCount] = useState(0);
    const token=getAuthToken();
    
    const getEvents=async()=>{
        setLoading(true);
        const [eventsData] = await Promise.all([
            fetchChallangesAll(selectedCategory,pageOffset+1,perPage)
        ]);

        if(eventsData.status===1){
            dispatch(fetchEventsAction(eventsData.data));
            setPageCount(eventsData.pagination.last_page);
        }
        setLoading(false);
    }

    const handlePageChange = (event) => {
        setPageOffset(event.selected);
    }

    useEffect(()=>{
        if (!isMounted) {
            setIsMounted(true); // Mark as mounted
            return; // Don't run the effect if it's the initial render
        }
        getEvents();
    },[isMounted, pageOffset, perPage]);
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    useEffect(()=>{
        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    },[currentUser]);

    return(
        <div className="main">
            <section>
                <div className="container">
                    <div className="d-flex justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
                        <div className="col-auto">
                            <h2 className="section-title mb-0">My Progress</h2>
                        </div>
                    </div>
                    <div className="position-relative">
                            <div className="row justify-content-start progress-table">
                                <div className="table-responsive">
                                    <table className="table mb-0">
                                        <thead>
                                            <tr>
                                            <th scope="col"></th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Category</th>
                                            <th scope="col">Type</th>
                                            <th scope="col">End Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Actions</th>
                                            </tr>
                                        </thead>
                                        {challangesList.length > 0 ? (
                                        challangesList.map((item) => (
                                            item.status === 'In Progress' && (
                                                <tbody key={item.id}>
                                                    <ProgressCard 
                                                        challangeItem={item} 
                                                        dispatch={dispatch} 
                                                        deleteChallangeAction={deleteEventAction} 
                                                        getEvents={getEvents} 
                                                        token={token} 
                                                        isShared={false} 
                                                    />
                                                </tbody>
                                            )
                                        ))
                                    ) : (
                                        !loading && (
                                            <tbody>
                                                <tr>
                                                    <td colSpan="7">
                                                        <div className="text-center py-3">
                                                            <p>Challenges not found.</p>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        )
                                    )}

                                    </table>
                                </div>
                            </div>                        
                            
                            {loading &&
                            <>
                                <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                                    <div className="lds-ripple"><div></div><div></div></div>
                                </div>
                            </>
                            }
                    </div>
                </div>                
            </section>
        </div>
    )
}
export default MyChallangesPage;