'use client';
import { usePathname } from "next/navigation";
import Link from "next/link";

export default function EventsLayout({ children }) {
    const pathname = usePathname();
    const internalMenu=[
        { name: 'Building Blocks', href: '/dashboard/wellness-center' },
        { name: 'My Challenges', href: '/dashboard/wellness-center/challanges' },
        { name: 'My Progress', href: '/dashboard/wellness-center/progress' },
        { name: 'Success Wall', href: '/dashboard/wellness-center/success-wall' }
    ];
    
    const isActive = (href) => {
        if (href === '/dashboard/wellness-center') {
            return pathname === href; // Only match exact path
        }
        
        return pathname === href || pathname.startsWith(href);
    };
    
    return(
        <div className="main">
            <section className="section-padding pt-100 horizontal-accordion">
                <div className="container">
                    <div className="row">
                        <div className="col-12 mb-40">
                            <h1 className="section-title">Wellness Center</h1>
                        </div>
                    </div>
                    <div className="row justify-content-center">
                        <div className="col-12">
                            <div className="overflow-auto overflow-md-visible">
                                <ul className="inner-menu d-flex flex-wrap">
                                    {internalMenu.map((item,index) => (
                                        <li key={index}>
                                            <Link className={`inner-menu-link ${isActive(item.href) ? 'active' : ''}`} href={item.href}>{item.name}</Link>
                                        </li>
                                    ))}
                                </ul>
                            </div>
                        </div>
                    </div>
                    {children}
                </div>                
            </section>
        </div>
    )
}