'use client'
import { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import BoxCardStyleOne from "@/components/BoxCards/BoxCardStyleOne";
import { usePathname } from "next/navigation";
import { getAuthToken } from "@/utils/auth";
import Link from "next/link";
import StartChallangesPopup from '@/components/Popups/StartChallangesPopup';
import { fetchStatistics, fetchAdminChallange } from "@/utils/apiActions";

const DashboardPage=()=>{
    const [loading, setLoading] = useState(false);
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    const [startChallanges, setStartChallanges] = useState(false);
    const [message, setMessage] = useState(null);
    const [adminData, setAdminData] = useState([]);    
    const token = getAuthToken();
    const [isMounted, setIsMounted] = useState(false);
    const [statisticData, setStatisticData] = useState([]);    

    const getStatistics = async () => {
        try {
            const [statisticData] = await Promise.all([fetchStatistics()]);
            setStatisticData(statisticData.data);
        } catch (error) {
            console.error("Error fetching statistics:", error);
        }
    };
    useEffect(() => {
        getStatistics();
    }, []);

    const getChallangs = async () => {
        setLoading(true);
        try {
            const adminDataResponse = await fetchAdminChallange();
            setAdminData(adminDataResponse.data);
        } catch (error) {
            console.error("Error fetching resources:", error);
        }
        setLoading(false);
    };

    const pathname = usePathname();
    const internalMenu=[
        { name: 'Building Blocks', href: '/dashboard/wellness-center' },
        { name: 'My Challenges', href: '/dashboard/wellness-center/challanges' },
        { name: 'My Progress', href: '/dashboard/wellness-center/progress' },
        { name: 'Success Wall', href: '/dashboard/wellness-center/success-wall' }
    ];
    
    const isActive = (href) => {
        if (href === '/dashboard/wellness-center') {
            return pathname === href;
        }
        return pathname === href || pathname.startsWith(href);
    };
    
    const startChallange = () => {
        setStartChallanges(true);
    };
    
    useEffect(()=>{
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        getChallangs();
        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    },[isMounted, currentUser]);

    return(
        <div className="main">
            <section className="section-padding pt-100 horizontal-accordion">
                <div className="container">
                    <div className="row">
                        <div className="col-12 mb-40">
                            <h1 className="section-title">Wellness Center</h1>
                        </div>
                    </div>
                    <div className="row justify-content-center">
                        <div className="col-12">
                            <div className="overflow-auto overflow-md-visible">
                                <ul className="inner-menu d-flex flex-wrap">
                                    {internalMenu.map((item,index) => (
                                        <li key={index}>
                                            <Link className={`inner-menu-link ${isActive(item.href) ? 'active' : ''}`} href={item.href}>{item.name}</Link>
                                        </li>
                                    ))}
                                </ul>
                            </div>
                        </div>
                    </div>                    
                    <div className="has-colored-text row justify-content-center">
                        <div className="col-md-5 col-sm-6 mb-30">
                            <Link href={'#'} onClick={startChallange} className="text-decoration-none text-black">
                                <BoxCardStyleOne 
                                    title="Start a New Challenge" 
                                    text={
                                        <>
                                          You have <b>({statisticData.total_active_challenges})</b> active challenges. Start a new challenge today and track your progress.
                                        </>
                                    }
                                    iconClass="ti-timer" 
                                />
                            </Link>
                        </div>
                        {startChallanges &&
                            <StartChallangesPopup setShowPopup={setStartChallanges} adminData={adminData} token={token} />
                        }
                        {message && (
                            <div className={`alert ${message.type === 'success' ? 'alert-success' : 'alert-danger'}`} role="alert">
                                {message.text}
                            </div>
                        )}
                        <div className="col-md-5 col-sm-6 mb-30">
                            <BoxCardStyleOne 
                                title="Daily Checkin" 
                                text={
                                    <>
                                      You have <b>({statisticData.active_daily_challenges_in_progress})</b> active daily challenges. Check in or create a new daily challenge today!
                                    </>
                                }
                                iconClass="ti-bar-chart" />                            
                        </div>
                        <div className="col-md-5 col-sm-6 mb-30">
                            <Link href={'/dashboard/wellness-center/challanges/create'} className="text-decoration-none text-black">
                                <BoxCardStyleOne 
                                    title="Create Your Own Challenge" 
                                    text="Create you own challenge to break old habits and create new goal oriented habits."
                                    iconClass="ti-hand-point-up" />
                            </Link>
                        </div>
                        <div className="col-md-5 col-sm-6 mb-30">
                            <Link href={'/dashboard/resource-center'} className='text-dark text-decoration-none'>
                            <BoxCardStyleOne 
                                title="Get Support" 
                                text="Need help? Visit the Resource Center where you will find tools and resources to help support your journey"
                                iconClass="ti-shine" />
                            </Link>
                        </div>
                    </div>
                </div>                
            </section>
        </div>
    )
}

export default DashboardPage;