'use client'
import { useState, useEffect } from "react";
import { useSelector } from "react-redux";
import Link from "next/link";
import { fetchChallangesAll, fetchAdminChallange } from "@/utils/apiActions";
import ChallangeCard from "@/components/Cards/ChallangeCard";
import { getAuthToken } from "@/utils/auth";
import { usePathname, useRouter } from "next/navigation";
import StartChallangesPopup from '@/components/Popups/StartChallangesPopup';

const MyChallangesPage = () => {
    const [loading, setLoading] = useState(false);
    const [challangesList, setChallangesList] = useState([]);
    const [message, setMessage] = useState(null);
    const [isMounted, setIsMounted] = useState(false);
    const [pageOffset, setPageOffset] = useState(1);
    const [selectedCategory, setSelectedCategory] = useState('all');
    const [hasMore, setHasMore] = useState(true);
    const perPage = 6;
    const token = getAuthToken();
    const [adminData, setAdminData] = useState([]);
    const router = useRouter();
    const pathname = usePathname();
    const [startChallanges, setStartChallanges] = useState(false);

    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;

    const getChallangs = async () => {
        if (loading || !hasMore) return;
        setLoading(true);
        try {
            const adminDataResponse = await fetchAdminChallange();
            setAdminData(adminDataResponse.data);
            
            const challangesData = await fetchChallangesAll(selectedCategory, pageOffset, perPage);
            if (challangesData.status === 1) {
                setChallangesList(prevList => {
                    const newList = [...prevList, ...challangesData.data].filter(
                        (item, index, self) => index === self.findIndex(t => t.id === item.id)
                    );
                    return newList;
                });
                setPageOffset(prevOffset => prevOffset + 1);
                if (challangesData.data.length < perPage) {
                    setHasMore(false);
                }
            } else {
                setHasMore(false);
            }
        } catch (error) {
            console.error("Error fetching resources:", error);
            setHasMore(false);
        }
        setLoading(false);
    };
       

    const startChallange = () => {
        setStartChallanges(true);
    };

    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        getChallangs();

        if (Object.keys(currentUser).length > 0) {
            if (!currentUser.subscription_status) {
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    }, [isMounted, selectedCategory, currentUser]);
    

    useEffect(() => {
        const handleScroll = () => {
            if (window.innerHeight + window.scrollY >= document.body.offsetHeight - 100 && !loading) {
                getChallangs();
            }
        };

        window.addEventListener("scroll", handleScroll);
        return () => window.removeEventListener("scroll", handleScroll);
    }, [loading, hasMore]);

    return (
        <>
            <div className="d-flex flex-wrap justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
                <div className="col-auto">
                    <h2 className="section-title mb-2 mb-md-0">My Challenges</h2>
                </div>
                <div className="d-flex justify-content-end align-items-start align-items-md-center mt-0 mt-md-2">
                    <div className="col-auto data-action-bar">
                        <button onClick={startChallange} type="button" className="data-action-cta data-action-cta-text shadow-sm"> Start Challenges</button>
                        <Link href={'/dashboard/wellness-center/challanges/create'} className="data-action-cta data-action-cta-text shadow-sm"><i className="ti-plus me-1"></i> Create Challenges</Link>
                    </div>
                </div>
            </div>
            {startChallanges &&
                <StartChallangesPopup setShowPopup={setStartChallanges} adminData={adminData} token={token} />
            }
            {message && (
                <div className={`alert ${message.type === 'success' ? 'alert-success' : 'alert-danger'}`} role="alert">
                    {message.text}
                </div>
            )}
            <div className="position-relative">
                <div className="row justify-content-start">
                    {challangesList.length > 0 ? (
                        challangesList.map((item) => (
                            <div className="col-md-4 mb-4" key={item.id}>
                                <ChallangeCard
                                    challangeItem={item}
                                    deleteChallangeAction={() => {}}
                                    getChallangs={getChallangs}
                                    token={token}
                                    isShared={false}
                                />
                            </div>
                        ))
                    ) : (
                        !loading && <p>Challenges not found.</p>
                    )}
                </div>
                {loading && hasMore && (
                    <div className="css-loader">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                )}
            </div>
        </>
    );
};

export default MyChallangesPage;
