"use client";
import React, { useState, useEffect } from "react";
import { fetchPlans, fetchInvoice, fetchUserDetail } from "@/utils/apiActions";

const SubscriptionPlan = () => {
  const [loading, setLoading] = useState(false);
  const [invoiceData, setInvoiceData] = useState([]);
  const [planData, setPlanData] = useState([]);
  const [userData, setUserData] = useState([]);

  const getPlans = async () => {
    setLoading(true);
    try {
      const plandata = await fetchInvoice();
      setPlanData(plandata.data);

      const invoicedata = await fetchPlans();
      setInvoiceData(invoicedata.data);

      const userDetails = await fetchUserDetail();
      setUserData(userDetails.data);
    } catch (error) {
      console.error("Error fetching resources:", error);
    }
    setLoading(false);
  };

  useEffect(() => {
    getPlans();
  }, []);

  return (
    <div className="main">
    <div className="pt-100 pb-100">
      <div className="container">
        <div className="row">
          <div className="col-md-12">
            <div className="border-bottom pb-2">
              <h2>Subscription</h2>
            </div>
            <div>
              {invoiceData.length > 0 ?
                <div>
                  <div className="row justify-content-center mt-5">
                    <div className="col-xl-6 col-md-6">
                      <div className="card rounded shadow border-0 mb-30">
                        <div className="card-body p-30">
                          <span className="h2 font-weight-bold d-inline-flex">
                            ${invoiceData[0].price}
                          </span>
                          <span className="text-monthly">
                            \{invoiceData[0].payment_frequency}
                          </span>
                          <h3 className="font-weight-600 mt-15 mb-0">
                            {invoiceData[0].name}
                          </h3>
                          <p className="border-bottom pb-15">
                            {invoiceData[0].subtitle}
                          </p>
                          <ul className="list-unstyled check-list-2 mt-30 mb-40">
                            <li className="mb-25">
                              <div
                                dangerouslySetInnerHTML={{
                                  __html: invoiceData[0].description,
                                }}
                              ></div>
                            </li>
                          </ul>
                            {userData.subscription_status === false ?
                                <div className="d-flex justify-content-center">
                                <a
                                    href="/dashboard/subscription"
                                    className="btn btn-outline-primary d-block"
                                >
                                    Subscribe Now
                                </a>
                                </div>
                            :
                                <p className="text-center text-success fw-bold">
                                You have already subscription
                                </p>
                            }
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                :
                <>
                {loading &&
                  <>
                  <div style={{width:'100%', height:'300px', position:'relative'}}>
                      <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                          <div className="lds-ripple"><div></div><div></div></div>
                      </div>
                  </div>
                  </>

                }
                </>
              }
            </div>
          </div>
        </div>
      </div>
    </div>
    </div>
  );
};

export default SubscriptionPlan;
