'use client';
import React, { useState, useEffect } from 'react';
import { fetchUserDetail, fetchPlans } from '@/utils/apiActions';
import { loadStripe } from '@stripe/stripe-js';
const stripePromise = loadStripe('pk_live_51M5Z61EwXrT6Qv7S0BzR9ReUdPBOYhiwbekhU15V5zeYd2ohsH4qumLonGApaoCw5pQVFUNG9fMXfFh0n87wvxj500GFG7KyTo');
const Subscription = () => {
    const [firstname, setFirstName] = useState('');
    const [email, setEmail] = useState('');
    const [phone, setPhone] = useState('');
    const [city, setCity] = useState('');
    const [state, setState] = useState('');
    const [postcode, setPostcode] = useState('');
    const [country_name, setCountryName] = useState('');
    const [plansData, setPlansData] = useState([]);


    useEffect(() => {
        getUserDetails();
        getPlans();
    }, []);

    const getUserDetails = async () => {
        try {
            const userDetails = await fetchUserDetail();
            setFirstName(userDetails.data.firstname || '');
            setEmail(userDetails.data.email || '');
            setPhone(userDetails.data.phone_number || '');
            setCity(userDetails.data.city || '');
            setState(userDetails.data.state || '');
            setPostcode(userDetails.data.postcode || '');
            setCountryName(userDetails.data.country_name || '');
        } catch (error) {
            console.error('Error fetching user details:', error);
        }
    };
    useEffect(() => {
        (async () => {
            try {
                const [userDetails, plansData] = await Promise.all([fetchUserDetail(), fetchPlans()]);
                setFirstName(userDetails.data.firstname || '');
                setEmail(userDetails.data.email || '');
                setPhone(userDetails.data.phone_number || '');
                setCity(userDetails.data.city || '');
                setState(userDetails.data.state || '');
                setPostcode(userDetails.data.postcode || '');
                setCountryName(userDetails.data.country_name || '');
                setPlansData(plansData.data);
            } catch (error) {
                console.error('Error fetching data:', error);
            }
        })();
    }, []);
    

    const getPlans = async () => {
        try {
            const plansdata = await fetchPlans();
            setPlansData(plansdata.data);
        } catch (error) {
            console.error('Error fetching plans:', error);
        }
    };

    const handleCheckout = async (e) => {
        e.preventDefault();
    
        try {
            const response = await fetch('/api/stripe-checkout', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    name: plansData[0]?.name,
                    email,
                    phone,
                    city,
                    state,
                    postcode,
                    country_name,
                    plan: plansData[0]?.price,
                }),
            });
    
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
    
            const session = await response.json();
            if (session.error) {
                console.error('Error creating session:', session.error);
                return;
            }
            const stripe = await stripePromise;
            const { error } = await stripe.redirectToCheckout({ sessionId: session.sessionId });
    
            if (error) {
                console.error('Error redirecting to checkout:', error);
            }
        } catch (error) {
            console.error('Error submitting form:', error);
        }
    };

    return (
        <div className="main">
            <div className="pt-50 pb-50">
                <div className="container">
                    <div className="row">
                        <div className="col-md-6">
                            <div className="max-w-sm mx-auto bg-white shadow rounded-lg p-2 p-md-4 rounded-3">
                                <div className="border-bottom pb-2 mb-3">
                                    <h4 className="fw-bold">Billing Address</h4>
                                </div>
                                <form onSubmit={handleCheckout}>
                                    <div className="mb-3">
                                        <input
                                            type="text"
                                            placeholder="First Name"
                                            className="form-control"
                                            value={firstname}
                                            onChange={(e) => setFirstName(e.target.value)}
                                            required
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="email"
                                            placeholder="Email"
                                            className="form-control"
                                            value={email}
                                            onChange={(e) => setEmail(e.target.value)}
                                            required
                                            readOnly
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="tel"
                                            maxLength="15"
                                            placeholder="Phone number"
                                            className="form-control"
                                            value={phone}
                                            onChange={(e) => setPhone(e.target.value.replace(/[^0-9]/g, ''))}
                                            required
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="text"
                                            placeholder="City"
                                            className="form-control"
                                            value={city}
                                            onChange={(e) => setCity(e.target.value)}
                                            required
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="text"
                                            placeholder="State"
                                            className="form-control"
                                            value={state}
                                            onChange={(e) => setState(e.target.value)}
                                            required
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="tel"
                                            maxLength="8"
                                            placeholder="Postcode"
                                            className="form-control"
                                            value={postcode}
                                            onChange={(e) => setPostcode(e.target.value.replace(/[^0-9]/g, ''))}
                                            required
                                        />
                                    </div>
                                    <div className="mb-3">
                                        <input
                                            type="text"
                                            placeholder="Country"
                                            className="form-control"
                                            value={country_name}
                                            onChange={(e) => setCountryName(e.target.value)}
                                            required
                                        />
                                    </div>

                                    <div className="mt-3 text-end">
                                        <button type="submit" className="btn btn-primary py-2">
                                            Pay Now
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>
                        <div className="col-md-6">
                            <div className="max-w-sm mx-auto bg-white shadow rounded-lg p-2 p-md-4 rounded-3">
                                <div className="border-bottom pb-2 mb-2">
                                    <h4 className="fw-bold">Your Order Summary</h4>
                                </div>
                                <ul className="list-none space-y-2">
                                    <li className="d-flex justify-content-between align-items-center mb-2 border-bottom pb-2">
                                        <span className="text-muted">{plansData[0]?.name}</span>
                                        <span className="text-muted">${plansData[0]?.price}</span>
                                    </li>
                                    <li className="d-flex justify-content-between align-items-center">
                                        <strong>Total</strong>
                                        <strong>${plansData[0]?.price}</strong>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default Subscription;
