import { useState, useEffect, useRef } from 'react';
import Link from 'next/link';
import { useSelector } from "react-redux";

const SingleComp = ({ data }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [isContentLong, setIsContentLong] = useState(false);
    const descriptionRef = useRef(null);
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;

    const checkContentLength = () => {
        if (descriptionRef.current) {
            setIsContentLong(descriptionRef.current.scrollHeight > descriptionRef.current.clientHeight);
        }
    };

    useEffect(() => {
        checkContentLength();
        window.addEventListener('resize', checkContentLength);
        
        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }

        return () => {
            window.removeEventListener('resize', checkContentLength);
        };
    }, [data.description, currentUser]);

    const toggleText = () => {
        setIsExpanded(!isExpanded);
    };

    return (
        <div className="card resources-main h-100">
            <div className="card-body">
                <div className="row">
                    <div className="col-md-12">
                        <h5 className="card-title mb-0 mb-1">{data.name}</h5>
                    </div>
                    <div className="col-md-12 text-start">
                        {data.category && (
                            <div>
                                <p className="text-sm text-gray-700 resource-category">
                                    {data.category.name}
                                </p>
                            </div>
                        )}
                    </div>
                    <div className="read-more-container border-bottom mt-2 mb-3 pb-3">
                        <p
                            ref={descriptionRef}
                            className={`description mb-2 ${isExpanded ? 'expanded' : 'collapsed'}`}
                            dangerouslySetInnerHTML={{ __html: data.description }}
                        />
                        {isContentLong && (
                            <button onClick={toggleText} className="read-more-btn mt-2 mt-md-0">
                                {isExpanded ? 'Read Less' : 'Read More'}
                            </button>
                        )}
                    </div>
                </div>
                <div className="resources-contact">
                    {data.contact_1 && (
                        <Link href={`tel:${data.contact_1}`}>
                            <i className="ti-mobile me-1"></i> <span>{data.contact_1}</span>
                        </Link>
                    )}
                    {data.email && (
                        <Link href={`mailto:${data.email}`}>
                            <i className="ti-email me-1"></i> {data.email}
                        </Link>
                    )}
                    {data.contact_2 && (
                        <Link href={`tel:${data.contact_2}`} className='website-btn'>
                            <i className="ti-mobile me-1"></i> {data.contact_2}
                        </Link>
                    )}
                    {data.website && (
                        <Link href={data.website} target='_blank' className='read-more-btn mt-2 mt-md-0 website-btn'>
                            <i className="ti-world me-1 me-2 mt-1"></i>Open Link
                        </Link>
                    )}
                </div>
            </div>
        </div>
    );
};

export default SingleComp;
