'use client'
import { useEffect, useState } from 'react';
import SingleComp from './singlecomp';
import { fetchResources } from "@/utils/apiActions";

const ResourceCenter = () => {
    const [resources, setResources] = useState([]);

    const getResources = async () => {
        try {
            const resourcesData = await fetchResources();
            setResources(resourcesData.data);
        } catch (error) {
            console.error("Error fetching resources:", error);
        }
    };

    useEffect(() => {
        getResources();
    }, []);

    return (
        <div className="main">
            <section className="section-padding pt-100 horizontal-accordion">
                <div className="container">
                    <div className="row">
                        <div className="col-12 mb-40">
                            <h1 className="section-title">Resource Center</h1>
                        </div>
                    </div>
                    <div className="row">
                        {resources.map((resource, index) => (
                            <div className="col-md-6 col-lg-4 mb-30" key={index}>
                                <SingleComp data={resource} />
                            </div>
                        ))}
                    </div>
                </div>
            </section>
        </div>
    );
};

export default ResourceCenter;
