'use client';
import { useState, useEffect } from "react";
import { isUserAuthenticated } from "@/utils/auth";
import Link from "next/link";
import Image from "next/image";
import { fetchUserDetail, fetchAllBadges } from "@/utils/apiActions";
import { Tooltip } from 'react-tooltip';
import 'react-tooltip/dist/react-tooltip.css';

const ProfilePage=()=>{
    const [isLoggedin, setIsLoggedin] = useState(false);
    const [loading, setLoading] = useState(false);
    const [currentUser, setCurrentUser] = useState({});
    const [isMounted, setIsMounted] = useState(false);
    const [badges, setBadges] = useState([]);
    const [userBadges, setUserBadges] = useState([]);
    const [planData, setPlanData] = useState([]);

    const getUserDetail=async()=>{
        setLoading(true);
        const [response, responseBadges] = await Promise.all([
            fetchUserDetail(),
            fetchAllBadges()
        ]);
        setCurrentUser(response.data);
        setBadges(responseBadges.data);     
        
        if(response?.badges.length > 0){
            var userbadgesArr = [];
            response?.badges.forEach((b)=>{
                userbadgesArr.push(b.badge_id);
            });

            setUserBadges(userbadgesArr);
        }
        setLoading(false);
    }

    useEffect(() => {
        // Check auth status on the client
        setIsLoggedin(isUserAuthenticated());
        if(!isUserAuthenticated()){
            window.location="/";
        }
    }, []);

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return ;
        }
        if(isLoggedin){
            getUserDetail();
        }
    },[isMounted]);

    const formatDate = (dateString) => {
        if (!dateString) return '';
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, "0");
        const month = String(date.getMonth() + 1).padStart(2, "0");
        const year = date.getFullYear();
        return `${month}-${day}-${year}`;
    };
    
    return(
        <div className="main">
             <section className="section-padding">
                <div className="container">
                    <div className="d-flex justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-gray pb-2">
                        <div className="col-auto">
                            <h2 className="section-title">Profile</h2>
                        </div>
                        <div className="col-auto data-action-bar">
                            <Link href={'/dashboard/profile/edit'} type="button" className="data-action-cta data-action-cta-text shadow-sm"><i className="ti-pencil-alt me-1"></i> Edit Profile</Link>
                        </div>
                    </div>                   
                </div>
                {!loading && Object.keys(currentUser).length>0 ?
                <div className="container">
                    <div className="shadow rounded bg-white mx-auto p-3 p-sm-4">
                        <div className="row">
                            <div className="col-12 col-md-6 col-lg-4 mb-20 text-center">
                                <div className={`position-relative rounded-circle profile-pic mb-4`}>
                                    <div className="rounded-circle overflow-hidden position-relative">
                                        {currentUser?.photo!==null ?
                                            <Image src={currentUser?.photo?.original_url} 
                                                alt="" 
                                                fill                                                                 
                                                className="mb-2 rounded-circle"
                                                style={{
                                                    objectFit: 'cover', // cover, contain, none
                                                }}
                                                />
                                        :
                                            <i className="ti-user"></i>
                                        }
                                    </div>
                                </div>
                                <div className="mb-3">
                                    {badges.length>0 &&
                                    <ul className="badges d-flex gap-2 gap-md-4 justify-content-center">
                                        {badges.map((badge)=>{
                                            return(
                                                <li key={badge.id} className={`${userBadges.includes(badge.id) ? 'bg-danger-subtle' : 'bg-dark-subtle'} rounded p-1 p-md-2`}>
                                                    <Image 
                                                        alt={badge.name}
                                                        src={badge.icon.original_url}
                                                        width={25}
                                                        height={25}
                                                        id={`badge-${badge.id}`}
                                                    />
                                                    <Tooltip anchorSelect={`#badge-${badge.id}`}><p>{badge.name}</p></Tooltip>
                                                </li>
                                            )
                                        })}
                                    </ul>
                                    }
                                </div>
                                <div className="text-start plan-details w-100">
                                    <p className="d-flex"><span className="me-auto">Active Plan</span> <span className="ms-auto">{currentUser.plan_name}</span></p>
                                    <p className="d-flex"><span className="me-auto">Expire on</span>  <span className="ms-auto">{formatDate(currentUser.plan_date)}</span></p>
                                </div>
                            </div>
                            <div className="mb-20 col-md-6 col-lg-8">
                                <div className="row">
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">First Name</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.firstname}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Last Name</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.lastname}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Phone Number</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.phone_number}</div>                                
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Date Of Birth</div>
                                        <div className="border-bottom border-grey pb-2">{formatDate(currentUser.dob)}</div>                                
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Gender</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.gender}</div>                                
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">City</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.city}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">State</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.state}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Postcode</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.postcode}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Country</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.country_name}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Address</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.address}</div>
                                    </div>
                                    <div className="mb-20 col-12 col-lg-6">
                                        <div className="font-weight-600 text-primary">Bio</div>
                                        <div className="border-bottom border-grey pb-2">{currentUser.bio}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                :
                <>
                <div className="container">
                    <div className="css-loader w-100 h-100">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </div>
                </>
                }
            </section>
        </div>
    )
}

export default ProfilePage;