'use client';
import { useState, useRef, useEffect } from 'react';
import { useSelector } from "react-redux";
import Image from "next/image";
import Link from "next/link";
import Inspiration from "@/components/Inspiration/Inspiration";
import Anouncement from '@/components/Announcement/Announcement';
import { usePathname } from 'next/navigation';
import { logoutUser } from '@/utils/auth';
import { fetchStatistics } from "@/utils/apiActions";

const DashboardPage = () => {
    const [statisticData, setStatisticData] = useState([]);    
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    const getStatistics = async () => {
        try {
            const [statisticData] = await Promise.all([fetchStatistics()]);
            setStatisticData(statisticData.data);
        } catch (error) {
            console.error("Error fetching statistics:", error);
        }
    };
    useEffect(() => {
        getStatistics();
    }, []);

    const handleLogout = () => {
        logoutUser();
        window.location.href = '/';
        if (isMenuOpen) {
            toggleMobileMenu();
        }
    };
    const [isOpen, setIsOpen] = useState(false);
    const pathname = usePathname();
    
    const isActive = (href) => {
        if (href === '/dashboard') {
            return pathname === href;
        }
        return pathname === href || pathname.startsWith(href);
    };

    const toggleMenu = () => {
        setIsOpen(!isOpen);
    };

    useEffect(() => {
        if (currentUser && Object.keys(currentUser).length > 0) {
            if (!currentUser.subscription_status) {
                window.location.replace("/dashboard/subscriptionplan");
            }
        }
    }, [currentUser]);

    const formatDate = (dateString) => {
        if (!dateString) return '';
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, "0");
        const month = String(date.getMonth() + 1).padStart(2, "0");
        const year = date.getFullYear();
        return `${month}-${day}-${year}`;
    };
    return (
        <>        
            <div className="main">
            {Object.keys(currentUser).length > 0 ?
                <>
                {currentUser.subscription_status === false ?
                    // <div className='container pt-100'>
                    //     <div className='row'>
                    //         <div className='col-md-12 mt-100 mb-100 text-center'>
                    //             <h2 className='text-uppercase'>You don&apos;t have any subscription.</h2>
                    //             <Link className="btn btn-primary mt-3" href={'/dashboard/subscriptionplan'}>Subscribe Now
                    //             </Link>
                    //         </div>
                    //     </div>
                    // </div>
                    <></>
                    :
                    <section className="section-padding section-dashboard pt-100 horizontal-accordion">
                        <div className="container">
                            <div className="row mb-md-40">
                                <div className="col-12 col-md-4 col-lg-3">
                                    <div className='d-bloack gap-1 gap-md-3 border p-2 p-md-3 rounded-3 sidebar-sticky'>
                                        <div className="profile-image overflow-hidden rounded-circle position-relative mx-auto">
                                            {Object.keys(currentUser).length > 0 && currentUser.photo !== null ?
                                                <>
                                                    <Image src={currentUser.photo.preview}
                                                        fill
                                                        alt=""
                                                        style={{
                                                            objectFit: 'cover',
                                                        }}
                                                        priority />
                                                </>
                                                :
                                                <>
                                                    <i className="ti-user"></i>
                                                </>
                                            }
                                        </div>
                                        <div className=' flex-grow-1 text-center border-bottom pb-3 mb-1 text-capitalize'>
                                            <p className='fw-bold'>{currentUser.firstname} {currentUser.lastname}</p>
                                            {(currentUser.city || currentUser.country_name) && (
                                                <div className="user-location">
                                                    {currentUser.city && currentUser.country_name 
                                                        ? `${currentUser.city}, ${currentUser.country_name}` 
                                                        : currentUser.city || currentUser.country_name}
                                                </div>
                                            )}

                                            <div className="text-start plan-details-dashboard w-100">
                                                <p className="d-flex"><span className="me-auto text-sm">Active Plan</span> <span className="ms-auto">{currentUser.plan_name}</span></p>
                                                <p className="d-flex mt-0"><span className="me-auto text-sm">Expire on</span>  <span className="ms-auto">{formatDate(currentUser.plan_date)}</span></p>
                                            </div>
                                        </div>
                                        <button
                                            className={`navbar-toggler d-flex d-md-none col-12 text-center justify-content-center px-2 px-md-4 py-2 mt-2 bg-gray-200 rounded ${isOpen ? 'show-Less ' : 'show-More'}`}
                                            onClick={toggleMenu}
                                            
                                        >
                                            {isOpen ? 'Show Less ' : 'Show More'} <i className="ti-angle-down ms-2"></i>
                                        </button>
                                        <ul className={`navbar-nav mx-auto transition-all duration-300 ease-in-out md:flex ${
                                            isOpen ? 'flex' : 'd-none d-md-flex'
                                            } `}>
                                                
                                            <li className={`nav-item rounded-2`}>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={'/dashboard'}>Welcome</Link>
                                            </li>
                                            <li className={`nav-item rounded-2`}>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={'/dashboard/events'}>Events<span className='bg-primary text-white rounded-pill count-show'>{statisticData.total_events}</span></Link>
                                            </li>
                                            <li className={`nav-item rounded-2`}>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={'/dashboard/friends-family'}>Friends & Family</Link>
                                            </li>
                                            <li className={`nav-item rounded-2`}>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={'/dashboard/wellness-center'}>Wellness Center<span className='bg-primary text-white rounded-pill count-show'>{statisticData.total_challenges}</span></Link>
                                            </li>
                                            <li className={`nav-item rounded-2`}>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={'/dashboard/resource-center'}>Resource Center<span className='bg-primary text-white rounded-pill count-show'>{statisticData.total_resource_center}</span></Link>
                                            </li>
                                            
                                            <li>
                                                <Link className="nav-link text-decoration-none d-flex justify-content-between" href={"dashboard/mypost"}>My Post <span className='bg-primary text-white rounded-pill count-show'>{statisticData.total_announcements}</span></Link>
                                            </li>
                                           
                                        </ul>
                                        <button onClick={handleLogout} className="btn py-0 px-0 d-none d-lg-block text-decoration-none text-white btn-primary w-100 py-1 mt-2">Logout</button>
                                    </div>
                                </div>
                                {currentUser.subscription_status !== false &&
                                    <div className="col-12 col-md-8 col-lg-9">
                                        <div className='col-md-12 border rounded-3 p-3 mb-3'>
                                            <h4 className="text-primary">Inspiration For Today!!</h4>
                                            <Inspiration />
                                        </div>
                                        <Anouncement />
                                    </div>
                                }
                            </div>
                            {/* <div className="row no-gutters">
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="Create An Event"
                                        text={`You have 0 events today. Create a new event and share with a family member or friend.`}
                                        iconClass="ti-calendar"
                                        hasLink="/dashboard/events/create" />
                                </div>
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="Start A Challenge"
                                        text={`You are participating in 0 challenges. Start a new challenge today and track your progress in the Wellness Center.`}
                                        iconClass="ti-timer" />
                                </div>
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="To Do List"
                                        text={`Your currently have 0 items on your things to do list. View and manage your list here.`}
                                        iconClass="ti-clipboard" />
                                </div>
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="My Goals"
                                        text={`You are currently pursuing 0 goals. Visit the Wellness Center to view your progress.`}
                                        iconClass="ti-bell" />
                                </div>
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="My Connections"
                                        text={`You currently have 0 connections.Send invitation and add connections to your Tree of Life.`}
                                        iconClass="ti-link" />
                                </div>
                                <div className="col-lg-4 col-md-6 service-box">
                                    <BoxCardStyleTwo
                                        title="Get Support"
                                        text={`Need help? Visit the Resource Center where you will find tools and resources to help support your journey.`}
                                        iconClass="ti-heart-broken"
                                        hasLink="#" />
                                </div>
                                <div className="col-12"><div className="border-bottom border-md-0"></div></div>
                            </div> */}
                        </div>
                    </section>
                }
                </>
                :
                <>
                <div style={{width:'100%', height:'300px', position:'relative'}}>
                    <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </div>
                </>
            }
            </div>
        </>        
    )
}

export default DashboardPage;
