"use client";
import React, { useState, useEffect } from "react";
import Link from "next/link";
import {fetchInvoice } from "@/utils/apiActions";

const MyTransactions = () =>{
    const [loading, setLoading] = useState(false);
    const [invoiceData, setInvoiceData] = useState([]);
     const getPlans = async () => {
        setLoading(true);
        try {
          const invoicedata = await fetchInvoice();
          setInvoiceData(invoicedata.data);
        } catch (error) {
          console.error("Error fetching resources:", error);
        }
        setLoading(false);
      };
    
      useEffect(() => {
        getPlans();
      }, []);

     // Date Format
    const formatDateTime = (dateString) => {
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, "0");
        const month = String(date.getMonth() + 1).padStart(2, "0");
        const year = date.getFullYear();
        const hours = String(date.getHours()).padStart(2, "0");
        const minutes = String(date.getMinutes()).padStart(2, "0");
        const seconds = String(date.getSeconds()).padStart(2, "0");
    
        return `${day}-${month}-${year} - ${hours}:${minutes}:${seconds}`;
    };
    return(
        <>
        <div className='main section-padding'>
            <div className="container">
                <div className="row">
                    <div className="col-12 border-bottom pb-3">
                        <h2 className="section-title mb-2 mb-md-0">My Transactions</h2>
                    </div>
                    <div className="col-12">
                        <div className="progress-table mt-5 table-responsive">
                            {loading ?
                                <div className="css-loader w-100">
                                    <div className="lds-ripple"><div></div><div></div></div>
                                </div>
                            :
                                invoiceData.length > 0 ?
                                    <>
                                        <table className="table mb-0 my-transaction-table">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Amount</th>
                                                    <th scope="col">Payment Type</th>
                                                    <th scope="col">Subscription ID</th>
                                                    <th scope="col">Created Date</th>
                                                    <th scope="col"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {invoiceData.map((invoice, index) => (
                                                    <tr key={invoice.subscription_id || index}>
                                                        <td className="fw-bold">${invoice.amount}</td>
                                                        <td className="text-capitalize">{invoice.payment_type}</td>
                                                        <td>{invoice.subscription_id}</td>
                                                        <td>{formatDateTime(invoice.created_at)}</td>
                                                        <td className="text-end">
                                                            <Link href={invoice.hosted_invoice_url} target="_blank" className="btn btn-primary btn-sm px-3 py-1 rounded-pill fw-semibold" role="button">
                                                                Download <i className="ti-download text-sm"></i>
                                                            </Link>
                                                        </td>
                                                    </tr>
                                                ))}
                                            </tbody>
                                        </table>
                                    </>
                                : 
                                    <h4 className="text-center py-3">No transactions found</h4>
                            }
                        </div>
                    </div>

                </div>
            </div>
        </div>
        </>
    )
}
export default MyTransactions;